;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(defvar namespacetypes)

(defun lookup-constant (id)
      (let ((pair (getl id '(scheme-constant constant-primitive
			   constant-system-function))))
	 (and pair (let ((value (cadr pair)))
		      (if (eq value 'unassigned-constant)
			  (raise (list 'SE%vsm '|Unassigned constant:| id))
			  value)))))

(defun declare-constant (c)
      (let ((pair (getl c namespacetypes)))
	 (if pair
	     (let ((type (car pair)))
		  (cond
		     ((eq type 'beta-transform)
		      (raise (list 'SE%constant
				   '|Special forms cannot be declared as constants:|
				   c)))
		     ((eq type 'system-function)
		      (rplaca pair 'constant-system-function))
		     ((eq type 'scheme-primitive)
		      (rplaca pair 'constant-primitive))))
	     (setf (get c 'scheme-constant)
		   (let ((cell (baselocation c)))
			       (if (null cell)
				   'unassigned-constant
				   (prog2 (removefrombase c) (cdr cell))))))))

(defun undeclare-constant (c)
      (let ((pair (getl c namespacetypes)))
	 (if pair
	     (let ((type (car pair)))
		  (cond
		     ((eq type 'constant-system-function)
			(rplaca pair 'system-function))
		     ((eq type 'constant-primitive)
			(rplaca pair 'scheme-primitive))
		     ((and (eq type 'scheme-constant)
			   (eq (cadr pair) 'unassigned-constant))
			(remprop c 'scheme-constant))
		     (t (extendbase c (cadr pair))
			(remprop c 'scheme-constant)))))))

(mapc (function declare-constant)
      '(save-defining-form load scheme-directory))
