; -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; File ssig.scm / Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Scheme signatures

; Total of 193 exported values

; The separation into core and non-core is very tentative for now.
; Could be split into two different signatures at some point.

(define revised^3-scheme-sig
  (make-signature
   'revised^3-scheme
   '(
     ;; Core
     * + - / < <= = > >=
     apply
     boolean?
     call-with-current-continuation
     car cdr
     char->integer
     char-ready?
     close-input-port close-output-port
     complex? cons current-input-port current-output-port
     eof-object? eq? eqv? exact->inexact exact?
     imag-part inexact->exact inexact? input-port?
     integer->char integer?
     load
     magnitude make-polar make-rectangular make-string
     make-vector modulo
     newline not null? number? 
     numerator
     open-input-file open-output-file output-port?
     pair? procedure?
     quotient
     rational? read-char real-part real?
     remainder
     set-car! set-cdr!
     string->symbol 
     string-length string-ref string-set!
     string? symbol->string symbol?
     transcript-on transcript-off
     vector-length vector-ref vector-set! vector?
     write-char

     ;; Non-core
     append assoc assq assv
     abs acos angle
     asin atan
     caaaar caaadr caadar caaddr caaar caadr caar
     cadaar cadadr caddar cadddr cadar caddr cadr
     call-with-input-file
     call-with-output-file
     cdaaar cdaadr cdadar cdaddr cdaar cdadr cdar
     cddaar cddadr cdddar cddddr cddar cdddr cddr
     ceiling
     char-alphabetic?
     char-ci<=? char-ci<? char-ci=? char-ci>=? char-ci>?
     char-downcase char-lower-case? char-numeric?
     char-upcase
     char-upper-case? char-whitespace? char<=? char<? char=?
     char>=? char>? char?
     cos
     denominator display
     equal? even? exp expt
     floor for-each force
     gcd
     last-pair lcm list log
     length list->string list->vector list-ref list-tail
     map max member memq memv min
     negative? nil number->string
     odd?
     positive? rationalize read reverse round sin sqrt 
     string->list string->number string-append
     string-ci<=? string-ci<? string-ci=? string-ci>=? string-ci>?
     string-copy string-fill!
     string<=? string<? string=? string>=? string>? substring t
     tan truncate
     vector vector->list vector-fill! with-input-from-file
     with-output-to-file write zero? 
     )
   ;; Private variables
   '(and-aux case-aux make-promise or-aux
     unspecified =>-aux
     core-scheme			;a structure; currently unused
     )))
