#| -*-Scheme-*-

$Header: filein.scm,v 14.7 90/11/09 08:43:43 GMT cph Rel $

Copyright (c) 1989, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; File Input Ports
;;; package: (runtime file-input)

(declare (usual-integrations))

(define (initialize-package!)
  (set! input-file-template
	(make-input-port `((BUFFER-SIZE ,operation/buffer-size)
			   (BUFFERED-CHARS ,operation/buffered-chars)
			   (CHANNEL ,operation/channel)
			   (CHAR-READY? ,operation/char-ready?)
			   (CHARS-REMAINING ,operation/chars-remaining)
			   (CLOSE ,operation/close)
			   (DISCARD-CHAR ,operation/discard-char)
			   (DISCARD-CHARS ,operation/discard-chars)
			   (EOF? ,operation/eof?)
			   (LENGTH ,operation/length)
			   (PATHNAME ,operation/pathname)
			   (PEEK-CHAR ,operation/peek-char)
			   (PRINT-SELF ,operation/print-self)
			   (READ-CHAR ,operation/read-char)
			   (READ-CHARS ,operation/read-chars)
			   (READ-STRING ,operation/read-string)
			   (REST->STRING ,operation/rest->string)
			   (SET-BUFFER-SIZE ,operation/set-buffer-size)
			   (TRUENAME ,operation/truename))
			 false))
  unspecific)

(define (open-input-file filename)
  (let ((pathname (->pathname filename)))
    (open-input-file/internal pathname
			      (canonicalize-input-pathname pathname))))

(define (open-input-file/internal pathname truename)
  (input-port/copy
   input-file-template
   (make-input-file-state
    (make-input-buffer (file-open-input-channel (pathname->string truename))
		       buffer-size)
    pathname
    truename)))

(define input-file-template)
(define buffer-size 512)

(define-structure (input-file-state
		   (type vector)
		   (conc-name input-file-state/))
  ;; Buffer must come first, so we can use operations from generic
  ;; input port implementation.
  (buffer false read-only true)
  (pathname false read-only true)
  (truename false read-only true))

(define (operation/length port)
  (file-length (operation/channel port)))

(define (operation/pathname port)
  (input-file-state/pathname (input-port/state port)))

(define (operation/print-self unparser-state port)
  (unparse-string unparser-state "for file: ")
  (unparse-object unparser-state (operation/truename port)))

(define (operation/rest->string port)
  ;; This operation's intended purpose is to snarf an entire file in
  ;; a single gulp, exactly what a text editor would need.
  (let ((buffer (input-file-state/buffer (input-port/state port))))
    (let ((remaining (input-buffer/chars-remaining buffer))
	  (fill-buffer
	   (lambda (string)
	     (let ((length (string-length string)))
	       (let loop ()
		 (or (input-buffer/read-substring buffer string 0 length)
		     (loop)))))))
      (if remaining
	  (let ((result (make-string remaining)))
	    (let ((n (fill-buffer result)))
	      (if (< n remaining)
		  (substring result 0 n)
		  result)))
	  (apply string-append
		 (let loop ()
		   (let ((string (make-string buffer-size)))
		     (let ((n (fill-buffer string)))
		       (cond ((zero? n) '())
			     ((< n remaining) (list (substring string 0 n)))
			     (else (cons string (loop))))))))))))

(define (operation/truename port)
  (input-file-state/truename (input-port/state port)))