/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $retr.P */

/* retract routines */

$retr_export([$retract/1,$retr_abolish/1,$retr_abolish/2,$update/2,
	      $retractall/1]).

$retr_use($decompile,[_,$clause/3,_,_]).

/* $retr_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$float/1,_,_]).
   $retr_use($buff,[$alloc_perm/2,$alloc_heap/2,$trimbuff/3,$buff_code/4,
		$symtype/2,
		$substring/6,$subnumber/6,$subdelim/6,$conlength/2,
		$pred_undefined/1, $hashval/3]).
   $retr_use($db,[$db_new_prref/1,$db_assert_fact/5,$db_add_clref/5,
	$db_call_prref/2,$db_call_prref_s/2,$db_call_prref_s/3,
	$db_call_clref/2,$db_get_clauses/3,$db_kill_clause/1]).
   $retr_use($assert,[$assert/1,$asserti/2,$assert_union/2,$assert_call_s/1,
		$assert_get_prref/2,$assert_put_prref/2,$assert_abolish_i/1]).
*/

/* this routine $retracts facts. It does so by running the chain of buffers,
   explicitly. When it finds a fact that unifies, it overwrites the first
   instruction in the buffer (after the retrymeelse instruction) to be a 
   fail. This is somewhat of a kludge but is easy. Besides you shouldn't be
   using $retract anyway. */

$retract(Clause) :-
	$retr_chk_clause(Clause) ->
	     ((Clause = (Head :- Body) ->
	          true ;
	          (Clause = Head, Body = true)
	      ),
	      $clause(Head,Body,Ref),
	      $erase(Ref)
	     ) ;
	     ($telling(X), $tell(stderr),
	      $write('*** Error: illegal argument to retract/1: '),
	      $write(Clause), $nl,
	      $told, $tell(X)
	     ).

$retr_chk_clause(Cl) :- $atom(Cl).
$retr_chk_clause(Cl) :-
     $structure(Cl),
     (Cl = (Hd :- Body) -> $retr_chk_hd(Hd) ; true).

$retr_chk_hd(Hd) :- $atom(Hd).
$retr_chk_hd(Hd) :- $structure(Hd), Hd \= (_ :- _).

$retr_abolish(Goal) :- $buff_code(Goal,0,11,0).
$retr_abolish(Pred,Arity) :-
	($atom(Pred), integer(Arity)) ->
		($functor(Term,Pred,Arity), $retr_abolish(Term)) ;
		($writename('*** abolish: illegal argument: '),
		 $write(Pred), $writename('/'), $write(Arity), $nl,
		 fail
		).

/* the following routines allow a tuple to be updated in a very limited way.
Using these operations, you can change the value of an existing tuple in the
database. The tuple must have been asserted, and only the first field
can be changed and only if it is a constant or an integer. */

/* $upda_clref(Newval,Clref): Newval must be bound to a constant or integer, 
and Clref must be bound to a clause reference. The first field of the tuple
in Clref must be a constant or integer. This operation resets that first 
field to Newval. */

$upda_clref(Newval,Clref) :- 
	integer(Newval),!,
	$buff_code(Clref,10,6 /*gb*/ ,14 /*getnumcon*/), /* right already */
	$buff_code(Clref,12,2 /*pn*/ ,Newval).

$upda_clref(Newval,Clref) :- 
	$atom(Newval),!,
	$buff_code(Clref,10,6 /*gb*/ ,4 /*getcon*/), /*must already be right*/
	$buff_code(Clref,12,1 /*pppsc*/ ,Newval).

$update(Fact,Newval) :-
	$assert_get_prref(Fact,Prref),$db_call_prref_s(Fact,Prref,Clref),
	$upda_clref(Newval,Clref).

$retractall(Hd) :-
     $retr_chk_hd(Hd) ->
          $retractall1(Hd) ;
	  ($telling(X), $tell(stderr),
	   $write('*** Error: illegal argument to retractall/1: '),
	   $write(Hd), $nl,
	   $told, $tell(X)
	  ).

$retractall1(Hd) :-
     $clause(Hd,_,Ref),
     $erase(Ref),
     fail.
$retractall1(_).


/* ------------------------------ $retr.P ------------------------------ */

