/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $prag.P */

$prag_export([$get_prag/2]).

/* $prag_use($name,[$name/2,_]).
   $prag_use($bio,[$writename/1,_,_,$nl/0,_,
		$tell/1,_,$telling/1,$told/0,_,_,$see/1,$seeing/1,$seen/0]).
   $prag_use($read,[$read/1,_]).
   $prag_use($blist,[$append/3,_,$member1/2]).
   $prag_use($bmeta,[$atom/1,_,_,_,_,_,_,_,_,_,_]).
*/


$get_prag(Infile,Prag) :-
	$name(Infile,InfileName), $append(InfileName,".def",PFileName),
	$name(PFile,PFileName),
	(
	 (($exists(PFile), PragFile = PFile, !) ;
	  ($name(DefFile,[100,101,102,115,47|PFileName]),  /* defs/foo.def */
	   $exists(DefFile), PragFile = DefFile, !
	  )
	 ),
	 $seeing(CurrIn), $see(PragFile),
	 $get_prag1(PragL,[]),
	 $seen, $see(CurrIn),
	 $sort_prag(PragL,Prag)
	) ;
	($telling(CurrOut), $tell(user),
	 $writename('*** warning: no pragma file for '),
	 $writename(Infile), $nl,
	 $told, $tell(CurrOut),
	 Prag = []
	).

$get_prag1(P,PTail) :-
	$read(Prag),
	(Prag = end_of_file -> P = PTail ;
			       (P = [Prag | PMid], $get_prag1(PMid,PTail))
	).

$sort_prag([],L) :- $prag_closetail(L), !.
$sort_prag([prag(P,N,Prag)|PRest],L) :-
	$prag_listify(Prag,PragL),
	$member1(prag(P,N,PragList),L),
	$prag_attach(PragL,PragList),
	$sort_prag(PRest,L).

$prag_listify(Prag,PragL) :- 
	Prag = [_|_] -> $append(Prag,_,PragL) ; PragL = [Prag|_].

$prag_attach(PragL,PragList) :-
	(var(PragList), PragList = PragL) ;
	(nonvar(PragList), PragList = [_|PragListTail],
	  $prag_attach(PragL, PragListTail)
	).

$prag_closetail([]).
$prag_closetail([prag(P,N,PragL)|L]) :-
	$prag_closetail0(PragL), $prag_closetail(L).

$prag_closetail0([]).
$prag_closetail0([_|L]) :- $prag_closetail0(L).

/* ------------------------------ $prag.P ------------------------------ */

