/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* subsumes.P */

subsumes(X,Y) :- not(X=Y),!,fail.
subsumes(X,Y) :- numbervars(Y,0,_),not(X=Y),!,fail.
subsumes(_,_).

numbervars(Y,I,J) :- var(Y),!,Y='$var'(I),J is I+1.
numbervars(Y,I,J) :- functor(Y,F,N),numvargs(Y,I,J,0,N).
numvargs(Y,I,I,N,N) :- !.
numvargs(Y,I,J,C,N) :- C1 is C+1, arg(C1,Y,A),numbervars(A,I,I1),
	numvargs(Y,I1,J,C1,N).
