/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* mode.P */

mode(M) :-
     functor(M,P,N),
     M =.. [_|Mode],
     mode(P,N,Mode).

mode(P,N,Mode) :-
    (symtype('_$mode'(_,_,_),K), K > 0, '_$mode'(P,N,Mode1)) ->
       ($same_mode(Mode,Mode1) ->
        (print('*** warning: multiple mode declarations for '),
         print(P), print('/'), print(N), $nl
        ) ;
        (print('*** Error: multiple distinct mode declarations for '),
         print(P), print('/'), print(N), $nl
        )
       ) ;
       ($length(Mode,N) ->
        ($mkmode(Mode,IMode,P,N),
         $asserti('_$mode'(P,N,IMode),1)
        ) ;
        (print('*** declared mode '), print(Mode), print(' for '), print(P),
         print('/'), print(N), print(' does not match predicate arity'), $nl
        )
       ).

$mkmode([],[],_,_).
$mkmode([M|MRest], [IM|IRest],P,N) :-
    ($mkmode1(M,IM) ->
        true ;
        ($writename('*** Unknown mode '),
         $write(M),
         $write(' in '), $write(P), $write('/'), $write(N),
         $write(' ***'),
         $nl,
         IM = 0
        )
    ),
    $mkmode(MRest,IRest,P,N).

$mkmode1('c', 2).
$mkmode1('nv', 1).
$mkmode1('d', 0).
$mkmode1('f', -1).

$mkmode1('++', 2).
$mkmode1('+', 1).
$mkmode1('?', 0).
$mkmode1('-', -1).

$same_mode([],[]).
$same_mode([X|L1],[Y|L2]) :-
     $mkmode1(X,Y),
     !,
     $same_mode(L1,L2).

