/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $targlist1.P */

/* **********************************************************************
$targlist1_export([$thead/8,$targlist/11,$targ_is/8]).

$targlist1_use($meta,[_,$univ/2,$length/2]).
$targlist1_use($blist,[_,_,$member1/2]).
$targlist1_use($glob,[_,$gennum/1,_]).
$targlist1_use($flatten1,[_,$flatten1/8]).
$targlist1_use($compare,['$=='/2,_,_,_,_,_,_]).
********************************************************************** */

$thead(Head,VidTbl,Prog,Targs,Oldclauses,Vlist,UniList,BindList) :-
    functor(Head,Pred,Arity),
    $targlist(Head,Arity,Targs,VidTbl,Vlist,0,0,1,UniList,BindList,0),
    $member1(preddef(Pred,Arity,Oldclauses,_),Prog).

$targlist(Term,Arity,Targs,VidTbl,Vlist,
			Pathno,Litno,Argno,UniList,BindList,LFlag) :-
    Argno =< Arity ->
    	(arg(Argno,Term,Arg),
	 Targs = [Targ|TargsRest],
	 $targ(Arg,Targ,VidTbl,Vlist,Pathno,Litno,Argno,UniList,BindList,LFlag),
	 Nextargno is Argno+1,
	 $targlist(Term,Arity,TargsRest,VidTbl,Vlist,Pathno,Litno,Nextargno,UniList,BindList,LFlag)
	) ;
	Targs = [].

$targ(X,TX,VidTbl,Vlist,Pathno,Litno,Argno,UniList,BindList,LFlag) :- 
    ((var(X), TX = v(Vid,Prag), $gennum(Vno), Prag = vrec(_,_,_,_),
      $targl_lookup_vid(X,VidTbl,Vid), $member1(v(Vid,Occlist),Vlist),
      (LFlag =:= 1 -> PathId = lastlit(Pathno) ; PathId = Pathno),
      $member1(o(Vno,PathId,Litno,Argno,t,Prag),Occlist)
     ) ;
     (nonvar(X), TX = [Str|Fflds], functor(X,Str,N),
      $tfldlist(X,1,N,Tflds,VidTbl,Vlist,Pathno,Litno,Argno,LFlag),
      $flatten1(Tflds,Vlist,Pathno,Litno,Argno,Fflds,UniList,BindList)
     )
    ).

$targ_is(X,TX,VidTbl,Vlist,Pathno,Litno,Argno,LFlag) :-
    ((var(X), TX = v(Vid,Prag), $gennum(Vno), 
      Prag = vrec(_,_,_,_),
      $targl_lookup_vid(X,VidTbl,Vid), $member1(v(Vid,Occlist),Vlist),
      (LFlag =:= 1 -> PathId = lastlit(Pathno) ; PathId = Pathno),
      $member1(o(Vno,PathId,Litno,Argno,t,Prag),Occlist)
     ) ;
     (nonvar(X), TX = [Str|Fflds], functor(X,Str,N),
      $tfldlist(X,1,N,Fflds,VidTbl,Vlist,Pathno,Litno,Argno,LFlag)
     )).


$tfldlist(T,N,Arity,Targ,VidTbl,Vlist,Pathno,Litno,Argno,LFlag) :-
    N =< Arity ->
	(arg(N,T,Fld), Targ = [Tfld|TfldRest],
	 $tfld(Fld,Tfld,VidTbl,Vlist,Pathno,Litno,Argno,LFlag),
	 N1 is N+1,
	 $tfldlist(T,N1,Arity,TfldRest,VidTbl,Vlist,Pathno,Litno,Argno,LFlag)
	) ;
	Targ = [].

$tfld(X,TX,VidTbl,Vlist,Pathno,Litno,Argno,LFlag) :- 
    (var(X), TX = v(Vid,Prag), $gennum(Vno),
     Prag = vrec(_,_,_,_),
     $targl_lookup_vid(X,VidTbl,Vid), $member1(v(Vid,Occlist),Vlist),
     (LFlag =:= 1 -> PathId = lastlit(Pathno) ; PathId = Pathno),
     $member1(o(Vno,PathId,Litno,Argno,s,Prag),Occlist)
    ) ;
    (nonvar(X), TX = [Str|Tflds], functor(X,Str,N),
     $tfldlist(X,1,N,Tflds,VidTbl,Vlist,Pathno,Litno,Argno,LFlag)
    ).

$targl_lookup_vid(V,VidTbl,Vid) :-
	((var(VidTbl), $gennum(Vid), VidTbl = [(V,Vid)|_]) ;
	 (nonvar(VidTbl), VidTbl = [(V1,Vid1)|VidRest],
	  (('$=='(V,V1), Vid = Vid1) ; ($targl_lookup_vid(V,VidRest,Vid)))
	 )
	).

/* ---------------------------- $targlist1.P ---------------------------- */

