/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $procclp1.P */

/* procclp([St|Clp]) processes the symbol table and determines where to
allocate variables and which are temporary and cetera.  It has an entry for
each variable in the program, and it fills in the pragma information.  It
does not fill in pragma information for the first occurrence of a variable.
That is determined by the translator.  These procedures are rather simple
and could be improved */ 

/* **********************************************************************
$procclp1_export([$procclp/2,$getnumlits/3]).

$procclp1_use($procvars1,[$procvars/2]).
$procclp1_use($alloctvars1,[$alloc_tvars/3]).
$procclp1_use($computil1,[_,_,_,_,_,_,_,_,_,_,_,$check_type/2,_,_,_,
				$misc/2,_,_,_,_]).
$procclp1_use($listutil1,[_,_,_,_,_,_,_,$closetail/1]).
$procclp1_use($blist,[_,_,$member1/2]).
********************************************************************** */

$procclp([st(Clist,Vlist)|Clp],LastGoals) :- 
    $getnumlits(Clist,0,Numlits),
    $procvars(Vlist,Numlits),
    $alloc_tvars(Vlist,st(Clist,Vlist),LastGoals),
    $procclp_closeocclist_tails(Vlist),
    !.

/*  "$getnumlits" computes the number of literals: it simply runs down the
     list of literals, and returns the max. literal number. This is necessary
     because inline predicates also have entries into the list of literals,
     but they have to be ignored when counting the number of chunks.	  */

$getnumlits([],N,N).
$getnumlits([c(L,_,_)|CRest],M,N) :-
	((L > M, M1 is L) ;
	 (L =< M, M1 is M)
	),
	$getnumlits(CRest,M1,N).

$procclp_closeocclist_tails([]).
$procclp_closeocclist_tails([v(_,Occlist)|VRest]) :-
    $procclp_closelelts(Occlist),
    $procclp_closeocclist_tails(VRest).

$procclp_closelelts([]).
$procclp_closelelts([o(_,_,_,_,_,P)|ORest]) :-
    $misc(P,Misc), $closetail(Misc),
    (($check_type(P,t),
      $member1(use(Uselist),Misc), $closetail(Uselist),
      $member1(nouse(Nouselist),Misc), $closetail(Nouselist)) ;
     true
    ),
    $procclp_closelelts(ORest).

/* end $procclp1.P **********************************************/
