/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $listutil1.P */

/*  some  Prolog  utilities  */

$listutil1_export([$reverse/2,$merge/3,$absmember/2,$absmerge/3,
		$nthmember/3,$nthmember1/3,$member2/2,$closetail/1]).

$listutil1_use($blist,[$append/3,$member/2,$member1/2]).
$listutil1_use($compare,['$=='/2,_,_,_,_,_,_]).


$reverse([], []).
$reverse([H | T], L) :- $reverse1(T,L,[H]).

$reverse1([],L,L).
$reverse1([H|T],L,L1) :- $reverse1(T,L,[H|L1]).

$merge([], L1, L1).
$merge([H|T], L1, L3) :- ($member(H, L1), $merge(T, L1, L3)) ;
			(L3 = [H | L4], $merge(T, L1, L4)).


/* "absmember" is similar to "member", except that it checks for identity
    rather than unifiability 						*/

$absmember(X, [H | T]) :- '$=='(X,H) ; $absmember(X, T).

/* "absmerge" is similar to "merge", except that it uses "absmember"
    rather than "member".						*/

$absmerge([], L1, L1).
$absmerge([H|T], L1, L3) :-
		($absmember(H, L1), $absmerge(T, L1, L3)) ;
		(L3 = [H | L4], $absmerge(T, L1, L4)).

:- index($nthmember,3,2).

$nthmember(X,[X|_],1).
$nthmember(X,[_|Rest],N) :- $nthmember(X,Rest,N1), nonvar(N1), N is N1 + 1.

$nthmember1(X,L,N) :- $nthmember1a(X,L,0,N).

:- index($nthmember1a,4,2).

$nthmember1a(X,[X|_],N,N) :- !.
$nthmember1a(X,[_|L],N,N1) :- N2 is N+1, $nthmember1a(X,L,N2,N1).

/* "member2" is used just to check for membership in a list whose tail is a
    variable. It fails if the element is not found.			*/

$member2(X,L) :- nonvar(L), L = [Y|Z], (X = Y ; $member2(X,Z)).

$closetail([]).
$closetail([_|L]) :- $closetail(L).

