/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $inline1.P */

/* inline checks to see if it's a pred that has code generated inline */

/* **********************************************************************
$inline1_export([$inline/2]).
********************************************************************** */

$inline(Pred,Arity) :-
	Arity =:= 3 -> $inline_3(Pred) ;
		((Arity =:= 2, $inline_2(Pred)) ;
		 (Arity =\= 2,
		  ((Arity =:= 1, $inline_1(Pred)) ;
		   (Arity =\= 1, $inline_0(Pred))
		  )
		 )
		).

$inline_3(arg).

$inline_2('=').
$inline_2('<').
$inline_2('=<').
$inline_2('>=').
$inline_2('>').
$inline_2('/\').
$inline_2('\/').
$inline_2('<<').
$inline_2('>>').
$inline_2('=:=').
$inline_2('=\=').
$inline_2(is).
$inline_2('?=').
$inline_2('\=').

$inline_1('\').
$inline_1('_$savecp').
$inline_1('_$cutto').
$inline_1('_$builtin').
$inline_1(nonvar).
$inline_1(var).
$inline_1(integer).
$inline_1(real).

$inline_0(fail).
$inline_0(true).
$inline_0(halt).

/* ------------------------------ $inline1.P ------------------------------ */

