/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $getclauses.P */

$getclauses_export([$getclauses/2,$getclauses/3,$attach/2,$expand_term/2]).

$getclauses_use($bio,[_,_,_,_,_,_,_,_,_,_,$see/1,$seeing/1,$seen/0]).
$getclauses_use($listutil1,[$reverse/2,$merge/3,$absmember/2,$absmerge/3,
		$nthmember/3,$nthmember1/3,$member2/2,$closetail/1]).
$getclauses_use($blist,[$append/3,$member/2,$member1/2]).
$getclauses_use($meta,[$functor/3,$univ/2,$length/2]).
$getclauses_use($read,[$read/1,$read/2]).

$getclauses(Filename,ClauseList) :- $getclauses(Filename,ClauseList,_).

$getclauses(Filename, ClauseList,PredList) :-
    $seeing(InStr),
    $see(Filename),
    $getclauses1(ClauseList0,[],PredList),
    $seen,
    $see(InStr),
    $getcl_collect(ClauseList0, ClauseList),
    $getcl_closetails(ClauseList).

$getclauses1(ClauseList,ClauseListTail,PredList) :-
    $read(T),
    $expand_term(T,T0),
    $fun_rel(T0,Cl),
    (Cl = end_of_file ->
    	(ClauseListTail = ClauseList,
    	 $closetail(PredList),
	 !
    	) ;
	(Cl = ':-'(Command) ->
		(call(Command),
		 $getclauses1(ClauseList,ClauseListTail,PredList)
		) ;
     		(ClauseList = [Cl | ClauseListRest],
    	 	 $getcl_pred(Cl,P,N),
	 	 $member1( (P/N), PredList),
      	 	 $getclauses1(ClauseListRest,ClauseListTail,PredList)
		)
	)
    ).

/*  "$getcl_collect" is used to gather together the clauses for individual
     predicates.  Each entry for a predicate is of the form

	   pred(Pred,Arity,CpyFlag,CutFlag,ClauseList).

     Once all the clauses have been read, the list of such 5-tuples
     that has been constructed will be traversed to set the values
     of "CpyFlag" and "CutFlag", which are as follows: if "CpyFlag"
     is 1 then the predicate contains constructs like cut, negation or
     if-then-else that require copying, while if it is 0 then it does
     not; "CutFlag" indicates whether or not the predicate contains cuts.
     This is useful because whenever cuts or negations are present, the
     program must be transformed to handle them, and this involves the
     creation of structures on the heap.
     
     Each clause is represented as terms of the form
     
     	fact(Fact,CpyFlagRest) or rule(Head,Body,CpyFlag,CpyFlagRest)
	
    where CpyFlag is 1 or 0 depending on whether the rule contains
    constructs like cut, negation or if-then-else, and CpyFlagRest gives
    the same information for the remaining clauses.			  */

$getcl_collect([],L) :- $closetail(L), !.
$getcl_collect([(H :- B)|PRest],L) :- !,
	$functor(H,Pred,Arity),
	$member1(pred(Pred,Arity,_,_,Clauses),L),
	$attach(rule(H,B,_,_),Clauses),
	$getcl_collect(PRest,L).
$getcl_collect([(Fact)|PRest],L) :-
	$functor(Fact,Pred,Arity),
	$member1(pred(Pred,Arity,_,_,Clauses),L),
	$attach(fact(Fact,_),Clauses),
	$getcl_collect(PRest,L).

$attach(X,Y) :- (var(Y), Y = [X|_]) ;
	       (nonvar(Y), Y = [_|T], $attach(X,T)).


$getcl_pred((H :- B),P,N) :- !, $functor(H,P,N).
$getcl_pred(Fact,P,N) :- $functor(Fact,P,N).

$getcl_closetails([]).
$getcl_closetails([Pred|PRest]) :-
	$getcl_closetails1(Pred), !, $getcl_closetails(PRest).

$getcl_closetails1(pred(P,N,_,_,Clauses)) :- $closetail(Clauses).

$expand_term(T1,T2) :- term_expansion(T1,T2), !.
$expand_term(T1,T2) :- functor(T1,'-->',2), !, $dcg(T1,T2).
$expand_term(T,T).

/* --------------------------- $getclauses.P --------------------------- */

