/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $geninline1.P */

/* generate inline code for inline predicates */

/* **********************************************************************
$geninline1_export([$geninline/7]).

$geninline1_use($eval1,[$eval_exp/7,$eval_arithreloptab/4,$arithrelop/1]).
$geninline1_use($computil1,[_,$hold/3,$release/3,
		$getreg/2,_,_,_,_,_,_,_,_,$type/2,$occ/2,$loc/2,_,
		$alloc_reg1/4,$alloc_reg/3,$release_if_done/6,_]).
$geninline1_use($blist,[$append/3,_,$member1/2]).
$geninline1_use($glob,[_,$gennum/1,_]).
$geninline1_use($aux1,[_,_,_,_,$umsg/1,_,$disj_targ_label/2,_,_]).
$geninline1_use($meta,[_,_,$length/2]).
$geninline1_use($bmeta,[_,_,_,$number/1,_,_,_,_,_]).
$geninline1_use($inst1,[$varinst/8,$coninst/5,$strinst/4,
					$varsubinst/7,$consubinst/3]).
********************************************************************** */

:- mode($geninline,7,[c,nv,d,d,d,d,d]).

$geninline(is,[Arg1,Arg2],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninline_is(Arg1,Arg2,HoldR,Pil,Pilr,Tin,Tout).
$geninline(fail,_,_,[fail|Pil],Pil,T,T).
$geninline(=,[Lhs,Rhs],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Lhs,R,Pil,Pil1,Tin,Tmid0,SaveReg),
   $geninl_par(h,Rhs,R,Pil1,Pilr,Hold1,Tmid0,Tmid1),
   $append(SaveReg,Tmid1,Tmid2),
   $geninl_unload_lhs(Lhs,R,Hold1,Tmid2,Tout).
$geninline('?=',[Lhs,Rhs],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Lhs,R1,Pil,Pil1,Tin,Tmid0,_),
   $geninl_load_lhs(Rhs,R2,Pil1,Pil2,Tmid0,Tmid1,_),
   $getreg(Tmid1,R3),
   Pil2 = [test_unifiable(R1,R2,R3),jumpz(R3,abs(-1))|Pilr],
   $geninl_unload_lhs(Rhs,R2,HoldR,Tmid1,Tout1),
   $geninl_unload_lhs(Lhs,R1,HoldR,Tout1,Tout).
$geninline('\=',[Lhs,Rhs],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Lhs,R1,Pil,Pil1,Tin,Tmid0,_),
   $geninl_load_lhs(Rhs,R2,Pil1,Pil2,Tmid0,Tmid1,_),
   $getreg(Tmid1,R3),
   Pil2 = [test_unifiable(R1,R2,R3),jumpnz(R3,abs(-1))|Pilr],
   $geninl_unload_lhs(Rhs,R2,HoldR,Tmid1,Tout1),
   $geninl_unload_lhs(Lhs,R1,HoldR,Tout1,Tout).
$geninline(Relop,Args,HoldR,Pil,Pilr,Tin,Tout) :-
   $arithrelop(Arithrelop),
   $geninl_relop(Relop,Args,HoldR,Pil,Pilr,Tin,Tout).
$geninline(integer,[Arg],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Arg,R1,Pil,Pil1,Tin,Tmid,_),
   Pil1 = [get_tag(R1,R2),putnumcon(6,R3),subreg(R2,R3),jumpnz(R3,abs(-1))|Pilr],
   $getreg(Tmid,R2), $getreg([R2|Tmid],R3),
   $geninl_unload_lhs(Arg,R1,HoldR,Tmid,Tout).
$geninline(real,[Arg],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Arg,R1,Pil,Pil1,Tin,Tmid,_),
   Pil1 = [get_tag(R1,R2),putnumcon(2,R3),subreg(R2,R3),jumpnz(R3,abs(-1))|Pilr],
   $getreg(Tmid,R2), $getreg([R2|Tmid],R3),
   $geninl_unload_lhs(Arg,R1,HoldR,Tmid,Tout).
$geninline(arg,[Index,Term,Arg],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Index,R1,Pil,Pil1,Tin,Tmid1,_),
   $geninl_load_lhs(Term,R2,Pil1,Pil2,Tmid1,Tmid2,_),
   $geninl_load_lhs(Arg,R3,Pil2,[ArgInst|Pilr],Tmid2,Tmid3,_),
   $geninl_arg(Arg,R1,R2,R3,ArgInst),
   $geninl_unload_lhs(Index,R1,HoldR,Tmid3,Tout1),
   $geninl_unload_lhs(Term,R2,HoldR,Tout1,Tout2),
   $geninl_unload_lhs(Arg,R3,HoldR,Tout2,Tout).
$geninline(var,[Arg],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Arg,R,Pil,[switchonterm(R,abs(-1),abs(-1))|Pilr],Tin,Tmid,_),
   $geninl_unload_lhs(Arg,R,HoldR,Tmid,Tout).
$geninline(nonvar,[Arg],HoldR,Pil,Pilr,Tin,Tout) :-
   $geninl_load_lhs(Arg,R,Pil,Pil1,Tin,Tmid,_),
   $gennum(LabId), $disj_targ_label(LabId,Lab), Label = (Lab,-1,LabId),
   Pil1 = [switchonterm(R,Label,Label),fail,label(Label)|Pilr],
   $geninl_unload_lhs(Arg,R,HoldR,Tmid,Tout).
$geninline(halt, [], _, [halt|Pilr], Pilr, T, T).
$geninline(true, [], _, Pil,Pil,T,T).
$geninline('_$builtin',[[N]],_,[builtin(N)|Pilr],Pilr,T,T) :-
	$number(N) ->
	    true ; 
	    $umsg('_$builtin: numeric argument expected').
$geninline('_$savecp',[Arg],_,Pil,Pilr,Tin,Tout) :-
	$geninline_cut('_$savecp',Arg,Pil,Pilr,Tin,Tout).
$geninline('_$cutto',[Arg],_,Pil,Pilr,Tin,Tout) :-
	$geninline_cut('_$cutto',Arg,Pil,Pilr,Tin,Tout).

$geninl_load_lhs(Term,R,Pil,Pilr,Tin,Tout,SaveR) :-
     Term \= v(_,_) ->
          ($getreg(Tin,R),
	   $hold(R,Tin,Tmid),
	   $geninl_par(b,Term,R,Pil,Pilr,[],Tmid,Tout),
	   SaveR = []
	  ) ;
	  (Term = v(Vid,Prag),
	   $alloc_reg(Prag,Tin,Tmid),
	   Prag = vrec(T,Oc,Loc,Misc),
	   (T ?= t ->
	        (R = Loc, Tout = Tmid,
	         (($member1(tail,Misc), SaveR = []) ; SaveR = [R])
	        ) ;
	        ($getreg(Tmid,R),
	         $hold(R,Tmid,Tout),
	         SaveR = []
	        )
	   ),
	   $varinst(b,Oc,T,Loc,R,Pil,Pilr,Tout)
	  ).

$geninl_unload_lhs(Term,R,HoldR,Tin,Tout) :-
     Term \= v(_,_) ->
	$release(R,Tin,Tout) ;
	(Term = v(Vid,Prag),
	 $release_if_done(Vid,R,Prag,HoldR,Tin,Tout)
	).

$geninline_is(V,Exp,HoldR,Pil,Pilr,Tin,Tout) :-
    V = v(Vid,Prag),
    !,
    $eval_exp(Exp,R,Pil,Pilm,HoldR,Tin,Tout1),
    $geninl_par(h,V,R,Pilm,Pilr,HoldR,Tout1,Tout).
$geninline_is(LHS,Exp,HoldR,Pil,Pilr,Tin,Tout) :-
    ((LHS = [Const], $number(Const),
      $getreg(Tin, R1), $hold(R1, Tin, Tmid),
      (integer(Const) -> Inst = putnumcon(Const,R1) ; Inst = putfloatcon(Const,R1)),
      Pil = [Inst|Pil1],
      $eval_exp(Exp,R,Pil1,
      		[subreg(R,R1),jumpnz(R1,abs(-1))|Pilr],HoldR,Tmid,Tout1),
      $release(R1,Tout1,Tout2), $release(R,Tout2,Tout)
     )
      ;
     ($umsg('*** error: variable or numerical constant expected as first argument of "is" ***'),
      Pil = [fail | Pilr], Tin = Tout)
    ). 

:- mode($geninline_cut,6,[c,c,d,d,d,d]).

$geninl_relop(Relop,[Arg1,Arg2],HoldR,Pil,Pilr,Tin,Tout) :-
	Arg2 = [0], !,
	$eval_exp(Arg1,R1,Pil,[Jumpinst|Pilr],HoldR,Tin,Tmid,1),
	$eval_arithreloptab(R1,Relop,abs(-1),Jumpinst),
	(Arg1 = v(Vid1,Prag1) ; (Vid1 = nonvbl, Prag1 = [])),
	$release_if_done(Vid1,R1,Prag1,HoldR,Tmid,Tout).
$geninl_relop(Relop,[Arg1,Arg2],HoldR,Pil,Pilr,Tin,Tout) :-
	Arg1 = [0], !,
	$geninl_invert(Relop,InvRelop),
	$eval_arithreloptab(R1,InvRelop,abs(-1),Jumpinst),
	$eval_exp(Arg2,R1,Pil,[Jumpinst|Pilr],HoldR,Tin,Tmid,1),
	(Arg2 = v(Vid1,Prag1) ; (Vid1 = nonvbl, Prag1 = [])),
	$release_if_done(Vid1,R1,Prag1,HoldR,Tmid,Tout).
$geninl_relop(Relop,[Arg1,Arg2],HoldR,Pil,Pilr,Tin,Tout) :-
	$eval_exp(Arg1,R1,Pil,Pilm,HoldR,Tin,Tmid),
	$eval_exp(Arg2,R2,Pilm,[subreg(R2,R1),Jump|Pilr],HoldR,Tmid,Tout1,1),
	$eval_arithreloptab(R1,Relop,abs(-1),Jump),
	(Arg1 \= v(_,_) ->
	     (Vid1 = nonvbl, Prag1 = []) ;
	     Arg1 = v(Vid1,Prag1)
	),
	(Arg2 \= v(_,_) ->
	     (Vid2 = nonvbl, Prag2 = []) ;
	     Arg2 = v(Vid2,Prag2)
	),
	$release_if_done(Vid1,R1,Prag1,HoldR,Tout1,Tout2),
	$release_if_done(Vid2,R2,Prag2,HoldR,Tout2,Tout).

$geninline_cut('_$savecp',v(_,Prag),[gettbreg(R)|Pilr],Pilr,Tin,Tout) :-
	$type(Prag,t), !,
	$alloc_reg(Prag,Tin,Tout),
	$loc(Prag,R).
$geninline_cut('_$savecp',v(_,Prag),[getpbreg(R)|Pilr],Pilr,T,T) :-
	$loc(Prag,R).
$geninline_cut('_$cutto',v(_,Prag),[puttbreg(R)|Pilr],Pilr,T0,T1) :-
	Prag = vrec(t,_,R,M),
	!,
	$alloc_reg(Prag,T0,Tmid),
	(($member1(tail,Misc),$release(R,Tmid,T1)) ; (Tmid = T1)).
$geninline_cut('_$cutto',v(_,Prag),[putpbreg(Loc)|Pilr],Pilr,T,T) :-
	$loc(Prag,Loc).

/*  "$geninl_par" is similar to "tpar" and used for a similar function -- code
     generation for parameters -- except that it is used for inlines, and
     does not deallocate registers as readily as tpar does.		*/

:- index($geninl_par, 8, 2).

$geninl_par(W,[Cid],N,Pil,Pilr,_,Tin,Tout) :- 
    $coninst(W,Cid,N,Pil,Pilr),
    (W ?= h ->
         $release(N,Tin,Tout) ;
	 Tin = Tout
    ).
$geninl_par(W,v(Vid,Prag),N,Pil,Pilr,HoldR,Tin,Tout) :-
     Prag = vrec(T,L,Loc,_),
     (W ?= h ->
          $release_if_done(Vid,N,Prag,HoldR,Tin,Tmid) ;
	  Tin = Tmid
     ),
     (T ?= t ->
           (T1 = t, $alloc_reg1(Prag,N,Tmid,Tout)) ;
           (T = T1, Tmid = Tout)
     ),
     $varinst(W,L,T1,Loc,N,Pil,Pilr,Tout).
$geninl_par(W,[Sid|Args],N,[Inst|Pil],Pilr,_,Tin,Tout) :-
    Args = [_|_],
    $length(Args,Arity),
    $strinst(W,(Sid,Arity),N,Inst),
    $geninl_subpars(W,Args,Pil,Pilr,Tin,Tout).


:- index($geninl_subpars, 6, 2).

/* loops through sub fields of a par */
$geninl_subpars(_,[],Pil,Pil,T,T).
$geninl_subpars(W,[Subpar|Subpars],Pil,Pilr,T1,T2) :-
    $geninl_subpar(W,Subpar,Pil,Pil1,T1,T3),
    $geninl_subpars(W,Subpars,Pil1,Pilr,T3,T2).


/* generates code for a subfield of par */

:- index($geninl_subpar, 6, 2).

$geninl_subpar(W,v(_,Prag),Pil,Pilr,Tin,Tout) :-
    $alloc_reg(Prag,Tin,Tout),
    $occ(Prag,L),  $loc(Prag,Loc), $type(Prag,T),
    $varsubinst(W,L,T,Loc,Pil,Pilr,Tout).

$geninl_subpar(W,[Cid],[Inst|Pilr],Pilr,T,T) :-
    $consubinst(W,Cid,Inst).

$geninl_invert('<','>').
$geninl_invert('=<','>=').
$geninl_invert('>','<').
$geninl_invert('>=','=<').
$geninl_invert('=:=','=:=').
$geninl_invert('=\=','=\=').

$geninl_arg(v(Vid,Prag),R1,R2,R3,arg0(R1,R2,R3)) :-
	$occ(Prag,f),	% first occurrence of the variable
	!.
$geninl_arg(_,R1,R2,R3,arg(R1,R2,R3)).

/* -------------------------- end $geninline1.P -------------------------- */

