/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $flatten1.P */

/* **********************************************************************
$flatten1_export([$add_uni_hdr/6,$flatten1/8]).

$flatten1_use($blist,[$append/3,_,$member1/2]).
$flatten1_use($listutil1,[_,_,_,_,_,_,$member2/2,_]).
$flatten1_use($glob,[_,$gennum/1,$gensym/2]).
$flatten1_use($meta,[_,_,$length/2]).
********************************************************************** */


/* "$add_uni_hdr" adds the unifications resulting from the flattening of
    nested structures in the head to the body of the clause.		*/

$add_uni_hdr([],_,_,_,TGoal, TGoal).
$add_uni_hdr([(V=S)|UniRest],A,NVars,Vlist,
		TGoal, and('_call'(=,[V,S],NV), _, UGoal1)) :-
    V = v(Vid,Prag), $member1(v(Vid,OccList),Vlist), Prag = vrec(_,_,_,_),
    $gennum(Vno), $member1(o(Vno,1,1,A,t,Prag),OccList),
    A1 is A+1, $member1(nv(NVars),NV),
    $add_uni_hdr(UniRest,A1,NVars,Vlist,TGoal, UGoal1).

/* 	"flatten" flattens each top-level argument, if necessary.	*/

$flatten(Var, _, _, _, _, Var, _, _) :- Var = v(_, _).
$flatten([Funcsym|ArgList],Vlist,Path,Lit,Arg,
			[Funcsym|NArgList],UniList,BindList) :-
	$flatten1(ArgList,Vlist,Path,Lit,Arg,NArgList,UniList,BindList).

/* "$flatten1" is given a list of the arguments of any structure at the top
   level.  Any structure found in this list is nested and has to be flattened.
   This flattening is done by flatten2, flatten1 just loops through calling
   flatten2 with each of the arguments in the list given.		*/

$flatten1([], _,_, _, _, [], _,_).
$flatten1([H|T],Vlist,Path,Lit,Arg, [FH|FT], UniList,BindList) :-
	$flatten2(H,Vlist,Path,Lit,Arg, FH, UniList,BindList),
	$flatten1(T, Vlist,Path,Lit,Arg, FT, UniList,BindList).
$flatten2(Var, _,_,_, _, Var, _,_) :- Var = v(_, _), !.
$flatten2(Cons,_,_,_, _, Cons, _,_) :-
	$length(Cons, L),
	L < 2,
	!.
$flatten2(Str, Vlist, Path, Lit,Arg, v(Temp, Prag), UniList,BindList) :-
	$flatten_make_var(Str,Vlist,UniList,
				BindList,Path,Lit,Arg,v(Temp,Prag),FStr),
	$flatten(Str, Vlist, Path, Lit, Arg, FStr, UniList,BindList).

/* "$flatten_make_var" is called with a structure Str, and returns a variable
    that replaces it in the process of flattening of nested structures. It
    first searches BindList to see whether the structure has already been
    flattened: if so, it returns the variable that had replaced it earlier,
    and enters occurrence info for the variable, as well as other such
    variables inside the flattened structure, into the symbol table: this may
    result in some temporary variables becoming permanent. If no such variable
    is found, a new one is generated.					*/

$flatten_make_var(Str,Vlist,UniList,BindList,Path,Lit,Arg,v(Vid,Prag),_) :-
		$member2((v(Vid, _),Str1),BindList),
		$flatten_same_str(Str, Str1), Prag = vrec(_,_,_,_),
		$member1(v(Vid, OccList), Vlist), $gennum(N),
		$member1(o(N,Path,Lit,Arg,s,Prag), OccList).

$flatten_make_var(Str,Vlist,UniList,BindList,Path,Lit,Arg,v(Vid,Prag),FStr) :-
		$gensym('$',Vid), $gennum(N),
		$member1(v(Vid, [o(N,Path,Lit,Arg,s,Prag)|_]), Vlist),
		$member1((v(Vid,_),Str),BindList), Prag = vrec(_,_,_,_),
		$member1((v(Vid,_) = FStr), UniList).

$flatten_same_str([], []).
$flatten_same_str(v(Vid, X), v(Vid, Y)).
$flatten_same_str([Func|Args1], [Func|Args2]) :-
	$flatten_same_str(Args1, Args2).

/* ---------------------------- $flatten1.P ---------------------------- */

