#!./perl

BEGIN {
    chdir 't' if -d 't';
    @INC = '../lib';
}

require "bigfloat.pl";

$test = 0;
$| = 1;
print "1..355\n";
while (<DATA>) {
	chop;
	if (/^&/) {
		$f = $_;
	} elsif (/^\$.*/) {
		eval "$_;";
	} else {
		++$test;
		@args = split(/:/,$_,99);
		$ans = pop(@args);
		$try = "$f('" . join("','", @args) . "');";
		if (($ans1 = eval($try)) eq $ans) {
			print "ok $test\n";
		} else {
			print "not ok $test\n";
			print "# '$try' expected: '$ans' got: '$ans1'\n";
		}
	}
} 
__END__
&fnorm
abc:NaN
   1 a:NaN
1bcd2:NaN
11111b:NaN
+1z:NaN
-1z:NaN
0:+0E+0
+0:+0E+0
+00:+0E+0
+0 0 0:+0E+0
000000  0000000   00000:+0E+0
-0:+0E+0
-0000:+0E+0
+1:+1E+0
+01:+1E+0
+001:+1E+0
+00000100000:+1E+5
123456789:+123456789E+0
-1:-1E+0
-01:-1E+0
-001:-1E+0
-123456789:-123456789E+0
-00000100000:-1E+5
123.456a:NaN
123.456:+123456E-3
0.01:+1E-2
.002:+2E-3
-0.0003:-3E-4
-.0000000004:-4E-10
123456E2:+123456E+2
123456E-2:+123456E-2
-123456E2:-123456E+2
-123456E-2:-123456E-2
1e1:+1E+1
2e-11:+2E-11
-3e111:-3E+111
-4e-1111:-4E-1111
&fneg
abd:NaN
+0:+0E+0
+1:-1E+0
-1:+1E+0
+123456789:-123456789E+0
-123456789:+123456789E+0
+123.456789:-123456789E-6
-123456.789:+123456789E-3
&fabs
abc:NaN
+0:+0E+0
+1:+1E+0
-1:+1E+0
+123456789:+123456789E+0
-123456789:+123456789E+0
+123.456789:+123456789E-6
-123456.789:+123456789E-3
&fround
$bigfloat::rnd_mode = 'trunc'
+10123456789:5:+10123E+6
-10123456789:5:-10123E+6
+10123456789:9:+101234567E+2
-10123456789:9:-101234567E+2
+101234500:6:+101234E+3
-101234500:6:-101234E+3
$bigfloat::rnd_mode = 'zero'
+20123456789:5:+20123E+6
-20123456789:5:-20123E+6
+20123456789:9:+201234568E+2
-20123456789:9:-201234568E+2
+201234500:6:+201234E+3
-201234500:6:-201234E+3
$bigfloat::rnd_mode = '+inf'
+30123456789:5:+30123E+6
-30123456789:5:-30123E+6
+30123456789:9:+301234568E+2
-30123456789:9:-301234568E+2
+301234500:6:+301235E+3
-301234500:6:-301234E+3
$bigfloat::rnd_mode = '-inf'
+40123456789:5:+40123E+6
-40123456789:5:-40123E+6
+40123456789:9:+401234568E+2
-40123456789:9:-401234568E+2
+401234500:6:+401234E+3
-401234500:6:-401235E+3
$bigfloat::rnd_mode = 'odd'
+50123456789:5:+50123E+6
-50123456789:5:-50123E+6
+50123456789:9:+501234568E+2
-50123456789:9:-501234568E+2
+501234500:6:+501235E+3
-501234500:6:-501235E+3
$bigfloat::rnd_mode = 'even'
+60123456789:5:+60123E+6
-60123456789:5:-60123E+6
+60123456789:9:+601234568E+2
-60123456789:9:-601234568E+2
+601234500:6:+601234E+3
-601234500:6:-601234E+3
&ffround
$bigfloat::rnd_mode = 'trunc'
+1.23:-1:+12E-1
-1.23:-1:-12E-1
+1.27:-1:+12E-1
-1.27:-1:-12E-1
+1.25:-1:+12E-1
-1.25:-1:-12E-1
+1.35:-1:+13E-1
-1.35:-1:-13E-1
-0.006:-1:+0E+0
-0.006:-2:+0E+0
$bigfloat::rnd_mode = 'zero'
+2.23:-1:+22E-1
-2.23:-1:-22E-1
+2.27:-1:+23E-1
-2.27:-1:-23E-1
+2.25:-1:+22E-1
-2.25:-1:-22E-1
+2.35:-1:+23E-1
-2.35:-1:-23E-1
-0.0065:-1:+0E+0
-0.0065:-2:-1E-2
-0.0065:-3:-6E-3
-0.0065:-4:-65E-4
-0.0065:-5:-65E-4
$bigfloat::rnd_mode = '+inf'
+3.23:-1:+32E-1
-3.23:-1:-32E-1
+3.27:-1:+33E-1
-3.27:-1:-33E-1
+3.25:-1:+33E-1
-3.25:-1:-32E-1
+3.35:-1:+34E-1
-3.35:-1:-33E-1
-0.0065:-1:+0E+0
-0.0065:-2:-1E-2
-0.0065:-3:-6E-3
-0.0065:-4:-65E-4
-0.0065:-5:-65E-4
$bigfloat::rnd_mode = '-inf'
+4.23:-1:+42E-1
-4.23:-1:-42E-1
+4.27:-1:+43E-1
-4.27:-1:-43E-1
+4.25:-1:+42E-1
-4.25:-1:-43E-1
+4.35:-1:+43E-1
-4.35:-1:-44E-1
-0.0065:-1:+0E+0
-0.0065:-2:-1E-2
-0.0065:-3:-7E-3
-0.0065:-4:-65E-4
-0.0065:-5:-65E-4
$bigfloat::rnd_mode = 'odd'
+5.23:-1:+52E-1
-5.23:-1:-52E-1
+5.27:-1:+53E-1
-5.27:-1:-53E-1
+5.25:-1:+53E-1
-5.25:-1:-53E-1
+5.35:-1:+53E-1
-5.35:-1:-53E-1
-0.0065:-1:+0E+0
-0.0065:-2:-1E-2
-0.0065:-3:-7E-3
-0.0065:-4:-65E-4
-0.0065:-5:-65E-4
$bigfloat::rnd_mode = 'even'
+6.23:-1:+62E-1
-6.23:-1:-62E-1
+6.27:-1:+63E-1
-6.27:-1:-63E-1
+6.25:-1:+62E-1
-6.25:-1:-62E-1
+6.35:-1:+64E-1
-6.35:-1:-64E-1
-0.0065:-1:+0E+0
-0.0065:-2:-1E-2
-0.0065:-3:-6E-3
-0.0065:-4:-65E-4
-0.0065:-5:-65E-4
&fcmp
abc:abc:
abc:+0:
+0:abc:
+0:+0:0
-1:+0:-1
+0:-1:1
+1:+0:1
+0:+1:-1
-1:+1:-1
+1:-1:1
-1:-1:0
+1:+1:0
+123:+123:0
+123:+12:1
+12:+123:-1
-123:-123:0
-123:-12:-1
-12:-123:1
+123:+124:-1
+124:+123:1
-123:-124:1
-124:-123:-1
&fadd
abc:abc:NaN
abc:+0:NaN
+0:abc:NaN
+0:+0:+0E+0
+1:+0:+1E+0
+0:+1:+1E+0
+1:+1:+2E+0
-1:+0:-1E+0
+0:-1:-1E+0
-1:-1:-2E+0
-1:+1:+0E+0
+1:-1:+0E+0
+9:+1:+1E+1
+99:+1:+1E+2
+999:+1:+1E+3
+9999:+1:+1E+4
+99999:+1:+1E+5
+999999:+1:+1E+6
+9999999:+1:+1E+7
+99999999:+1:+1E+8
+999999999:+1:+1E+9
+9999999999:+1:+1E+10
+99999999999:+1:+1E+11
+10:-1:+9E+0
+100:-1:+99E+0
+1000:-1:+999E+0
+10000:-1:+9999E+0
+100000:-1:+99999E+0
+1000000:-1:+999999E+0
+10000000:-1:+9999999E+0
+100000000:-1:+99999999E+0
+1000000000:-1:+999999999E+0
+10000000000:-1:+9999999999E+0
+123456789:+987654321:+111111111E+1
-123456789:+987654321:+864197532E+0
-123456789:-987654321:-111111111E+1
+123456789:-987654321:-864197532E+0
&fsub
abc:abc:NaN
abc:+0:NaN
+0:abc:NaN
+0:+0:+0E+0
+1:+0:+1E+0
+0:+1:-1E+0
+1:+1:+0E+0
-1:+0:-1E+0
+0:-1:+1E+0
-1:-1:+0E+0
-1:+1:-2E+0
+1:-1:+2E+0
+9:+1:+8E+0
+99:+1:+98E+0
+999:+1:+998E+0
+9999:+1:+9998E+0
+99999:+1:+99998E+0
+999999:+1:+999998E+0
+9999999:+1:+9999998E+0
+99999999:+1:+99999998E+0
+999999999:+1:+999999998E+0
+9999999999:+1:+9999999998E+0
+99999999999:+1:+99999999998E+0
+10:-1:+11E+0
+100:-1:+101E+0
+1000:-1:+1001E+0
+10000:-1:+10001E+0
+100000:-1:+100001E+0
+1000000:-1:+1000001E+0
+10000000:-1:+10000001E+0
+100000000:-1:+100000001E+0
+1000000000:-1:+1000000001E+0
+10000000000:-1:+10000000001E+0
+123456789:+987654321:-864197532E+0
-123456789:+987654321:-111111111E+1
-123456789:-987654321:+864197532E+0
+123456789:-987654321:+111111111E+1
&fmul
abc:abc:NaN
abc:+0:NaN
+0:abc:NaN
+0:+0:+0E+0
+0:+1:+0E+0
+1:+0:+0E+0
+0:-1:+0E+0
-1:+0:+0E+0
+123456789123456789:+0:+0E+0
+0:+123456789123456789:+0E+0
-1:-1:+1E+0
-1:+1:-1E+0
+1:-1:-1E+0
+1:+1:+1E+0
+2:+3:+6E+0
-2:+3:-6E+0
+2:-3:-6E+0
-2:-3:+6E+0
+111:+111:+12321E+0
+10101:+10101:+102030201E+0
+1001001:+1001001:+1002003002001E+0
+100010001:+100010001:+10002000300020001E+0
+10000100001:+10000100001:+100002000030000200001E+0
+11111111111:+9:+99999999999E+0
+22222222222:+9:+199999999998E+0
+33333333333:+9:+299999999997E+0
+44444444444:+9:+399999999996E+0
+55555555555:+9:+499999999995E+0
+66666666666:+9:+599999999994E+0
+77777777777:+9:+699999999993E+0
+88888888888:+9:+799999999992E+0
+99999999999:+9:+899999999991E+0
&fdiv
abc:abc:NaN
abc:+1:abc:NaN
+1:abc:NaN
+0:+0:NaN
+0:+1:+0E+0
+1:+0:NaN
+0:-1:+0E+0
-1:+0:NaN
+1:+1:+1E+0
-1:-1:+1E+0
+1:-1:-1E+0
-1:+1:-1E+0
+1:+2:+5E-1
+2:+1:+2E+0
+10:+5:+2E+0
+100:+4:+25E+0
+1000:+8:+125E+0
+10000:+16:+625E+0
+10000:-16:-625E+0
+999999999999:+9:+111111111111E+0
+999999999999:+99:+10101010101E+0
+999999999999:+999:+1001001001E+0
+999999999999:+9999:+100010001E+0
+999999999999999:+99999:+10000100001E+0
+1000000000:+9:+1111111111111111111111111111111111111111E-31
+2000000000:+9:+2222222222222222222222222222222222222222E-31
+3000000000:+9:+3333333333333333333333333333333333333333E-31
+4000000000:+9:+4444444444444444444444444444444444444444E-31
+5000000000:+9:+5555555555555555555555555555555555555556E-31
+6000000000:+9:+6666666666666666666666666666666666666667E-31
+7000000000:+9:+7777777777777777777777777777777777777778E-31
+8000000000:+9:+8888888888888888888888888888888888888889E-31
+9000000000:+9:+1E+9
+35500000:+113:+3141592920353982300884955752212389380531E-34
+71000000:+226:+3141592920353982300884955752212389380531E-34
+106500000:+339:+3141592920353982300884955752212389380531E-34
+1000000000:+3:+3333333333333333333333333333333333333333E-31
$bigfloat::div_scale = 20
+1000000000:+9:+11111111111111111111E-11
+2000000000:+9:+22222222222222222222E-11
+3000000000:+9:+33333333333333333333E-11
+4000000000:+9:+44444444444444444444E-11
+5000000000:+9:+55555555555555555556E-11
+6000000000:+9:+66666666666666666667E-11
+7000000000:+9:+77777777777777777778E-11
+8000000000:+9:+88888888888888888889E-11
+9000000000:+9:+1E+9
+35500000:+113:+314159292035398230088E-15
+71000000:+226:+314159292035398230088E-15
+106500000:+339:+31415929203539823009E-14
+1000000000:+3:+33333333333333333333E-11
$bigfloat::div_scale = 40
&fsqrt
+0:+0E+0
-1:NaN
-2:NaN
-16:NaN
-123.456:NaN
+1:+1E+0
+1.44:+12E-1
+2:+141421356237309504880168872420969807857E-38
+4:+2E+0
+16:+4E+0
+100:+1E+1
+123.456:+1111107555549866648462149404118219234119E-38
+15241.383936:+123456E-3
