(* BUG*)

signature BUG = 
sig
  structure LK_Rule: LK_RULE
  local open LK_Rule.Pure
  in
    val cut_tac: string -> int -> tactic
    val cut_left_tac: string -> int -> tactic
    val cut_right_tac: string -> int -> tactic
  end
end;


functor BugFun (structure LK_Rule: LK_RULE) : BUG = 
struct
structure LK_Rule = LK_Rule
local open LK_Rule  LK_Rule.Pure  LK_Rule.LK_Syntax
in 


(*For "cutting in" an arbitrary formula*)
fun cut_tac (sP: string) = res_inst_tac [ ("P",sP,Aform) ] cut;

(*Cut and thin, replacing the right-side formula*)
fun cut_right_tac (sP: string) i = 
    cut_tac sP i  THEN  resolve_tac [thin_right] i;

(*Cut and thin, replacing the left-side formula*)
fun cut_left_tac (sP: string) i = 
    cut_tac sP i  THEN  resolve_tac [thin_left] (i+1);

(*Thinning a formula on the right*)
fun thin_right_tac (sP: string) = res_inst_tac [ ("P",sP,Aform) ] thin_right;

end;
end;
