(*  Title: 	LK/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Adds Classical Sequent Calculus to a database containing pure Isabelle. 
Should be executed in the subdirectory LK.

To build system, enter Poly/ML and type
    PolyML.use "ROOT";
*)

writeln"Root file for Classical Sequent Calculus";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 1;  
structure LK_Syntax = LK_SyntaxFun(Syntax);
structure LK_Rule = LK_RuleFun(structure LK_Syntax=LK_Syntax and Pure=Pure);
structure LK_Resolve = LK_ResolveFun(structure LK_Rule=LK_Rule);

print_depth 0;  
open Pure;
open LK_Syntax LK_Rule LK_Resolve;

(*read/print functions*)
Unify.printer := Syntax.prin syn;

print_depth 8;  
