(*  Title: 	HOL/ex/hard-quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Hard examples with quantifiers.  Can be read to test the system.
From  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.

by (Pc.step_tac asms 1);
by (Pc.fast_tac asms 1);
by (Pc.comp_step_tac asms);
by (Pc.comp_tac asms);
by (Pc.best_tac asms);
*)

writeln"HOL/ex/hard-quant: Hard examples with quantifiers";

writeln"Problem 18.  The assumption a:A is essential";
val asms =
goal HOL_Rule.thy
    "a : A ==> EX y:A. ALL x:A. P(y)-->P(x)";
by (Pc.comp_tac asms);
result(); 



writeln"Problem 19. ";
val asms =
goal HOL_Rule.thy
    "a : A ==> EX x:A. ALL y:A. ALL z:A. (P(y)-->Q(z)) --> (P(x)-->Q(x))";
by (Pc.comp_tac asms);
(* or faster: (resolve_tac [exists_cintr] 1 THEN pc_tac asms 1) *)
result();


writeln"Problem 20.  The assumption d:D is essential";
val asms =
goal HOL_Rule.thy
    "d : D ==> (ALL x:A. ALL y:B. EX z:C. ALL w:D. (P(x)&Q(y)-->R(z)&S(w)))  \
\   --> (EX x:A. EX y:B. P(x) & Q(y)) --> (EX z:C. R(z))";
by (Pc.fast_tac asms 1); 
result();



writeln"Problem 21.  ";
val asms =
goal HOL_Rule.thy
    "(EX x:A. P-->Q(x)) & (EX x:A. Q(x)-->P)  --> (EX x:A. P<->Q(x))";
by (Pc.comp_tac asms); 
result();


writeln"Problem 22";
val asms =
goal HOL_Rule.thy
    "a : A ==> (ALL x:A. P <-> Q(x))  -->  (P <-> (ALL x:A. Q(x)))";
by (Pc.fast_tac asms 1); 
result();


writeln"Problem 23";
val asms =
goal HOL_Rule.thy "(ALL x:A. P | Q(x))  <->  (P | (ALL x:A. Q(x)))";
by (Pc.best_tac asms);  
result();


writeln"Problem 24";
val asms =
goal HOL_Rule.thy
    "a : A ==> ~(EX x:A. S(x)&Q(x)) & \
\    (ALL x:A. P(x) --> Q(x)|R(x)) &  \
\    ~(EX x:A.P(x)) --> (EX x:A.Q(x)) &  \
\    (ALL x:A. Q(x)|R(x) --> S(x))       --> (EX x:A. P(x)&R(x))";
by (Pc.fast_tac asms 1); 
result();


writeln"Problem 25";
val asms =
goal HOL_Rule.thy
    "(EX x:A. P(x)) &  \
\    (ALL x:A. L(x) --> ~ (M(x) & R(x))) &  \
\    (ALL x:A. P(x) --> (M(x) & L(x))) &   \
\    ((ALL x:A. P(x)-->Q(x)) | (EX x:A. P(x)&R(x)))  \
\   --> (EX x:A. Q(x)&P(x))";
by (Pc.best_tac asms); 
result();


writeln"Problem 27";
val asms =
goal HOL_Rule.thy
    "(EX x:A. P(x) & ~Q(x)) &   \
\    (ALL x:A. P(x) --> R(x)) &   \
\    (ALL x:A. M(x) & L(x) --> P(x)) &   \
\    ((EX x:A. R(x) & ~ Q(x)) --> (ALL x:A. L(x) --> ~ R(x)))  \
\   --> (ALL x:A. M(x) --> ~L(x))";
by (Pc.best_tac asms); 
result();


writeln"Problem 28.  AMENDED";
val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x) --> (ALL x:A. Q(x))) &   \
\    ((ALL x:A. Q(x)|R(x)) --> (EX x:A. Q(x)&S(x))) &  \
\    ((EX x:A.S(x)) --> (ALL x:A. L(x) --> M(x)))  \
\   --> (ALL x:A. P(x) & L(x) --> M(x))";
by (Pc.fast_tac asms 1);  
result();


writeln"Problem 29.  Essentially the same as Principia Mathematica *11.71";
val asms =
goal HOL_Rule.thy
    "(EX x:A. P(x)) & (EX y:B. Q(y))  \
\   --> ((ALL x:A. P(x)-->R(x)) & (ALL y:B. Q(y)-->S(y))   <->     \
\        (ALL x:A. ALL y:B. P(x) & Q(y) --> R(x) & S(y)))";
by (Pc.fast_tac asms 1); 
result();


writeln"Problem Problem 30";
val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x) | Q(x) --> ~ R(x)) & \
\    (ALL x:A. (Q(x) --> ~ S(x)) --> P(x) & R(x))    --> (ALL x:A. S(x))";
by (Pc.fast_tac asms 1);  
result();


writeln"Problem 31.  ";
val asms =
goal HOL_Rule.thy
    "~(EX x:A.P(x) & (Q(x) | R(x))) & \
\    (EX x:A. L(x) & P(x)) & \
\    (ALL x:A. ~ R(x) --> M(x))   --> (EX x:A. L(x) & M(x))";
by (Pc.fast_tac asms 1);
result();


writeln"Problem 32.  ";
val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x) & (Q(x)|R(x))-->S(x)) & \
\    (ALL x:A. S(x) & R(x) --> L(x)) & \
\    (ALL x:A. M(x) --> R(x))  \
\   --> (ALL x:A. P(x) & M(x) --> L(x))";
by (Pc.best_tac asms);
result();


writeln"Problem 33";
val asms =
goal HOL_Rule.thy
    "[| a: A;  b: A;  c: A |] ==> (ALL x:A. P(a) & (P(x)-->P(b))-->P(c))  <->    \
\    (ALL x:A. (~P(a) | P(x) | P(c)) & (~P(a) | ~P(b) | P(c)))";
by (Pc.best_tac asms);
result();


writeln"Problem 35.  ";
val asms =
goal HOL_Rule.thy
    "[| a : A;  b : B |] ==> EX x:A. EX y:B. P(x,y) -->  (ALL u:A. ALL v:B. P(u,v))";
by (Pc.comp_tac asms);
result();


writeln"Problem 36.  ";
val asms =
goal HOL_Rule.thy
    "(ALL x:A. EX y:A. J(x,y)) & \
\    (ALL x:A. EX y:A. G(x,y)) & \
\    (ALL x:A. ALL y:A. J(x,y) | G(x,y) -->	\
\    (ALL z:A. J(y,z) | G(y,z) --> H(x,z)))   \
\   --> (ALL x:A. EX y:A. H(x,y))";
by (Pc.fast_tac asms 1);


writeln"Problem 37";
val asms =
goal HOL_Rule.thy
    "(ALL z:A. EX w:A. ALL x:A. EX y:A. \
\       (P(x,z)-->P(y,w)) & P(y,z) & (P(y,w) --> (EX u:A.Q(u,w)))) & \
\    (ALL x:A. ALL z:A. ~P(x,z) --> (EX y:A. Q(y,z))) & \
\    ((EX x:A. EX y:A. Q(x,y)) --> (ALL x:A. R(x,x)))  \
\   --> (ALL x:A. EX y:A. R(x,y))";
by (Pc.fast_tac asms 1);
result();


writeln"Problem 39";
val asms =
goal HOL_Rule.thy
    "~ (EX x:A. ALL y:A. J(x,y) <-> ~J(y,y))";
by (Pc.fast_tac asms 1);
result();


writeln"Problem 40.  AMENDED";
val asms =
goal HOL_Rule.thy
    "(EX y:A. ALL x:A. J(y,x) <-> ~J(x,x))  \
\   -->  ~ (ALL x:A. EX y:A. ALL z:A. J(z,y) <-> ~ J(z,x))";
by (Pc.fast_tac asms 1);
result();



writeln"Reached end of file.";

(*24 August 1988: loaded in 688 seconds*)
(*10 September 1988: loaded in 443 seconds*)
