(*  Title: 	FOL/ex/int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Intuitionistic First-Order Logic

Single-step commands:
by (step_tac 1);
by (biresolve_tac safe_brls 1);
by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
by (safe_tac 1);
by (mp_tac 1);
by (pc_tac 1);
*)

writeln"File FOL/ex/int.";

goal Int_Rule.thy "~ ~ ((P --> Q | R)  -->  (P-->Q) | (P-->R))";
by (pc_tac 1);
result();

goal Int_Rule.thy "(P<->Q) <-> (Q<->P)";
by (pc_tac 1);
result();


writeln"Lemmas for the propositional double-negation translation";

goal Int_Rule.thy "P --> (~ ~ P)";
by (pc_tac 1);
result();

goal Int_Rule.thy "~ ~ (~ ~ P --> P)";
by (pc_tac 1);
result();

goal Int_Rule.thy "(~ ~ P) & ~ ~ (P --> Q) --> (~ ~ Q)";
by (pc_tac 1);
result();

goal Int_Rule.thy "~ ~ ~ P --> ~ P";
by (pc_tac 1);
result();


writeln"The following are classically but not constructively valid.";

(*The attempt to prove them terminates quickly!*)
goal Int_Rule.thy "((P-->Q) --> P)  -->  P";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
(*Check that subgoals remain: proof failed.*)
getgoal 1;  

goal Int_Rule.thy "(P&Q-->R)  -->  (P-->R) | (Q-->R)";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1;  


writeln"Intuitionistic FOL: propositional problems based on Pelletier.";

writeln"Problem 1";
goal Int_Rule.thy "~ ~ ((P-->Q)  <->  (~Q --> ~P))";
by (pc_tac 1);
result();
(*5 secs*)


writeln"Problem 2";
goal Int_Rule.thy "~ ~ (~ ~ P  <->  P)";
by (pc_tac 1);
result();
(*1 secs*)


writeln"Problem 3";
goal Int_Rule.thy "~(P-->Q) --> (Q-->P)";
by (pc_tac 1);
result();

writeln"Problem 4";
goal Int_Rule.thy "~ ~ ((~P-->Q)  <->  (~Q --> P))";
by (pc_tac 1);
result();
(*9 secs*)

writeln"Problem 5";
goal Int_Rule.thy "~ ~ ((P|Q-->P|R) --> P|(Q-->R))";
by (pc_tac 1);
result();
(*10 secs*)


writeln"Problem 6";
goal Int_Rule.thy "~ ~ (P | ~ P)";
by (pc_tac 1);
result();

writeln"Problem 7";
goal Int_Rule.thy "~ ~ (P | ~ ~ ~ P)";
by (pc_tac 1);
result();

writeln"8.  Peirce's law";
goal Int_Rule.thy "~ ~ (((P-->Q) --> P)  -->  P)";
by (pc_tac 1);
result();

writeln"Problem 9";
goal Int_Rule.thy "((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q)";
by (pc_tac 1);
result();
(*9 secs*)


writeln"Problem 10";
goal Int_Rule.thy "(Q-->R) --> (R-->P&Q) --> (P-->(Q|R)) --> (P<->Q)";
by (pc_tac 1);
result();

writeln"11.  Proved in each direction (incorrectly, says Pelletier!!) ";
goal Int_Rule.thy "P<->P";
by (safe_tac 1);

writeln"12.  Dijkstra's law  ";
goal Int_Rule.thy "~ ~ (((P <-> Q) <-> R)  -->  (P <-> (Q <-> R)))";
by (pc_tac 1);
result();
(*55 secs.  MUCH SLOWER THAN IT SHOULD BE!!*)

goal Int_Rule.thy "((P <-> Q) <-> R)  -->  ~ ~ (P <-> (Q <-> R))";
by (pc_tac 1);
result();
(*23 secs*)

writeln"13.  Distributive law";
goal Int_Rule.thy "P | (Q & R)  <-> (P | Q) & (P | R)";
by (pc_tac 1);
result();
(*9 secs*)

writeln"14";
goal Int_Rule.thy "~ ~ ((P <-> Q) <-> ((Q | ~P) & (~Q|P)))";
by (pc_tac 1);
result();
(*28 secs*)

writeln"15";
goal Int_Rule.thy "~ ~ ((P --> Q) <-> (~P | Q))";
by (pc_tac 1);
result();
(*4 secs*)

writeln"16";
goal Int_Rule.thy "~ ~ ((P-->Q) | (Q-->P))";
by (pc_tac 1);
result();
(*2.4 secs*)

(*17**********************
goal Int_Rule.thy
  "~ ~ (((P & (Q-->R))-->S) <-> ((~P | Q | S) & (~P | ~R | S)))";
by (pc_tac 1);    
DIDN'T TERMINATE**********)


writeln"Examples with quantifiers";



writeln"The converse is classical in the following implications...";

goal Int_Rule.thy "(EX x.P(x)-->Q)  -->  (ALL x.P(x)) --> Q";
by (pc_tac 1); 
(*2 secs*)
result();  


goal Int_Rule.thy "((ALL x.P(x))-->Q) --> ~ (ALL x. P(x) & ~Q)";
by (pc_tac 1); 
(*6 secs*)
result();  

goal Int_Rule.thy "((ALL x. ~P(x))-->Q)  -->  ~ (ALL x. ~ (P(x)|Q))";
by (pc_tac 1); 
(*10 secs*)
result();  

goal Int_Rule.thy "(ALL x.P(x)) | Q  -->  (ALL x. P(x) | Q)";
by (pc_tac 1); 
result();  

goal Int_Rule.thy "(EX x. P --> Q(x)) --> (P --> (EX x. Q(x)))";
by (pc_tac 1);
result();  


writeln"The following are not constructively valid!";
(*The attempt to prove them terminates quickly!*)

goal Int_Rule.thy "((ALL x.P(x))-->Q) --> (EX x.P(x)-->Q)";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 

goal Int_Rule.thy "(P --> (EX x.Q(x))) --> (EX x. P-->Q(x))";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 

goal Int_Rule.thy "(ALL x. P(x) | Q) --> ((ALL x.P(x)) | Q)";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 

goal Int_Rule.thy "(ALL x. ~ ~ P(x)) --> ~ ~ (ALL x. P(x))";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 


(*Classically but not intuitionistically valid
   Proved via a bug in previous versions*)
goal Int_Rule.thy "EX x. Q(x) --> (ALL x. Q(x))";
by (pc_tac 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 

writeln"Reached end of file.";
