(*  Title: 	CTT/rew
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Simplifier
*)

print_depth 1;

(*Make list of Eq_elim RES Prod_elim RES Prod_elim ... RES Prod_elim
  for using assumptions as rewrite rules*)
fun pe_elims 0 = []
  | pe_elims n = Eq_elim :: map (apr(op RES,Prod_elim)) (pe_elims (n-1));

(*Tactic used for proving conditions for the cond_rls*)
val prove_cond_tac = eresolve_tac (pe_elims 5);



print_depth 1;

structure Simp_data: SIMP_DATA =
struct
  structure Pure = Pure
  val refl= refl_elem
  val sym= sym_elem
  val trans= trans_elem
  val refl_red= refl_red
  val trans_red= trans_red
  val red_if_equal= red_if_equal
  val default_rls = comp_rls
  val routine_tac = routine_tac routine_rls
end;

structure Simp = SimpFun (Simp_data);

val standard_congr_rls = intr_long2_rls @ elim_long_rls;

(*Make a rewriting tactic from a normalization tactic*)
fun make_rew_tac ntac =
    TRY eqintr_tac  THEN  TRYALL (resolve_tac [Simp.split_eqn])  THEN  
    ntac;

fun rew_tac thms = make_rew_tac
    (Simp.norm_tac(standard_congr_rls, thms));

fun hyp_rew_tac thms = make_rew_tac
    (Simp.cond_norm_tac(prove_cond_tac, standard_congr_rls, thms));

