signature Vector =
sig

(* CONSTANT VECTOR CONVERSION FUNCTIONS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	28 Feb 1989

   Maintenance:	Author


   DESCRIPTION

   These functions are separated from the other basic functions on vectors
   so that the other functions can be used by StringType, which is used by
   InStream, which is used both here and in List, which is also used here.


   SEE ALSO

   RefVector.


   NOTES

   A possible implementation would be a view of a random access file.
   Possibly there should be a ConstVector signature (combining the Const
   and Vector signatures) to make this easier.
*)

  include Vector'

  val version: real
   (* version = 0.1 *)


(* SEQUENCE *)

  type 'a T
    sharing type T = Vector

  val stringSep: string -> string -> string ->
                 ('a -> string) -> 'a Vector -> string

  val string: ('a -> string) -> 'a Vector -> string

  exception Sep of string * string * string * string

  val parseSepN: string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 Nat -> string -> ('a Vector, 'a Vector Option) Result

  val parseSep: string -> string -> string ->
                (string list -> ('a * string list, 'b) Result) ->
                string -> ('a Vector, 'a Vector Option) Result

  val parse: (string list -> ('a * string list, 'b) Result) ->
             string -> ('a Vector, 'a Vector Option) Result

  val parseN: (string list -> ('a * string list, 'b) Result) ->
              Nat -> string -> ('a Vector, 'a Vector Option) Result

  val parseSepN': string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 Nat -> string list ->
                 ('a Vector * string list,
		  'a Vector Option * string list) Result

  val parseSep': string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 string list ->
                 ('a Vector * string list,
		  'a Vector Option * string list) Result

  val parse': (string list -> ('a * string list, 'b) Result) ->
              string list ->
              ('a Vector * string list, 'a Vector Option * string list) Result

  val parseN': (string list -> ('a * string list, 'b) Result) ->
               Nat -> string list ->
               ('a Vector * string list, 'a Vector Option * string list) Result

  val readSep: string -> string -> string ->
               (InStream -> ('a, 'b) Result) -> InStream ->
               ('a Vector, 'a Vector Option) Result

  val readSepN: string -> string -> string ->
               (InStream -> ('a, 'b) Result) -> Nat -> InStream ->
               ('a Vector, 'a Vector Option) Result

  val read: (InStream -> ('a, 'b) Result) -> InStream ->
            ('a Vector, 'a Vector Option) Result

  val readN: (InStream -> ('a, 'b) Result) -> Nat -> InStream ->
             ('a Vector, 'a Vector Option) Result

  val eq: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool

  val ne: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool

  val lt: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool

  val le: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool

  val gt: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool

  val ge: ('a -> 'a -> bool) -> 'a Vector -> 'a Vector -> bool


(* CONVERTERS *)

  val fromFile: (InStream -> ('a, 'b) Result) -> string -> 'a Vector
   (* fromFile p name; reads the contents of the file called name into a
      Vector, using the function p.  Stops reading from the file if p returns
      Fail.  Raises General.Io if something goes wrong. *)

  val file: ('a -> string) -> 'a Vector -> string -> unit
   (* file p v name; write the contents of v to the new file called name, using
      the function p.  Raises General.Io if something goes wrong. *)

end
