
structure IntObject: Object =

(* INTEGERS

   Created by:	Dave Berry LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author
*)

struct

  val version = 0.1


(* TYPES *)

  type T = int


(* OBSERVERS *)

  val fixedWidth = false

  fun lt x y = (x: int) < y
  fun gt x y = (x: int) > y
  fun le x y = (x: int) <= y
  fun ge x y = (x: int) >= y
  fun eq x y = (x: int) = y
  fun ne x y = (x: int) <> y


(* CONVERTERS *)

  local 
    fun string' 0 = "0"
    |   string' 1 = "1"
    |   string' 2 = "2"
    |   string' 3 = "3"
    |   string' 4 = "4"
    |   string' 5 = "5"
    |   string' 6 = "6"
    |   string' 7 = "7"
    |   string' 8 = "8"
    |   string' 9 = "9"
    |   string' n = string' (n div 10) ^ string' (n mod 10)
  in
    fun string n = if n < 0 then "~" ^ string' (~n) else string' n
  end

  val zero = ord "0"
  local
    fun parseInt' ([], n) = OK (n, [])
    |   parseInt' (s as h::t, n) =
          if StringType.isDigit h then
            parseInt' (t, n * 10 + ord h - zero)
	  else OK (n, s)

    fun parseInt [] = Fail (None, [])
    |   parseInt (h::t) =
	  if StringType.isDigit h
	  then parseInt' (t, ord h - zero)
	       handle
	         Sum => Fail (None, [])
	       | Plus => Fail (None, [])
	  else Fail (None, [])
  in
    fun parse' l =
          case
            (List'.dropPrefix (not o StringType.isVisible) l)
          of [] => Fail (None, [])
          |  (l as h::t) =>
	       if h = "~" then
		 case
		   parseInt t
		 of OK (n, s) => OK (~n, s)
		 |  Fail x => Fail x
	       else parseInt l
  end

  local
    fun readInt' (i, n) =
          let val s = InStream.lookahead i
          in if s = "" then OK n
	     else if not (StringType.isDigit s) then OK n
             else (InStream.input1 i; readInt' (i, n * 10 + ord s - zero))
          end

    fun readInt s i =
	  if not (StringType.isDigit s) then Fail None
	  else (InStream.input1 i;
		readInt' (i, ord s - zero))
	       handle
	         Sum => Fail None
	       | Plus => Fail None
  in
    fun read i =
        ( InStream.skip (not o StringType.isVisible) i;
	  if InStream.eof i then Fail None
	  else if InStream.lookahead i = "~"
	  then let val s = (InStream.input1 i; InStream.lookahead i)
	       in case readInt s i of
		    OK n => OK (~n)
		  | Fail x => Fail x
	       end
	  else readInt (InStream.lookahead i) i
        )
  end

  fun parse s =
	case parse' (explode s) of
	  OK (l, _) => OK l
        | Fail _ => Fail None
end
