#include <signal.h>
#include <mlvalues.h>
#include <signals.h>
#include "unix.h"

extern int signal_table[];             /* defined in kill.c */

static unsigned char * sighandler_code;

value unix_install_signal_handler(sighandler) /* ML */
     value sighandler;
{
  sighandler_code = Code_val(sighandler);
  return Atom(0);
}

static sighandler_return_type unix_signal_handler(sig)
     int sig;
{
  signal(sig, unix_signal_handler);
  signal_handler = sighandler_code;
  signal_number = sig;
  execute_signal();
}

value unix_set_signal(sig, behavior) /* ML */
     value sig, behavior;
{
  int s = signal_table[Tag_val(sig)];

  switch (Int_val(behavior)) {
  case 0:                       /* Signal_default */
    signal(s, SIG_DFL);
    break;
  case 1:                       /* Signal_ignore */
    signal(s, SIG_IGN);
    break;
  case 2:                       /* Signal_handle */
    signal(s, unix_signal_handler);
    break;
  }
  return Val_int(s);
}
