/*******************************************************************
                 Le-Lisp (r) version 15.24

		 Bibliothe`que d'Exe'cution en C
	 utilisable sur syste`me d`exploitation "a` la UN*X"

 *****************************************************************
 (r) Le-Lisp est une marque de'pose'e de l'INRIA
 *****************************************************************
 Ce fichier est en lecture seule.  Il est maintenu par :
       ILOG S.A.
       2 Avenue Gallie'ni
       BP 85
       94253 Gentilly Cedex
 *****************************************************************

$Header: /nfs/work/v15.2/sun/RCS/execore.c,v 1.3 90/09/25 11:59:16 kerjean Exp $

 *******************************************************************/

/* les includes */

#include <sys/types.h> /* for every body */
#include <sys/stat.h>  /* for every body */
#include <signal.h>    /* for signals */
#include <stdio.h>     /* for input ouput */
#include <errno.h>     /* for perror, and save-core BSD */
#include <a.out.h>     /* for getglobal, and save-core BSD */

/* Variables defined in exelelisp.c */
extern int corscons;
extern int corbtbin;
extern int corstbin;
extern int scons;
extern int stbin;
extern int btbin;

/* Absolute path of binary lelispbin */
extern char lelispbin[256]; /* change by cload */
extern char realbin[256];   /* do not change by cload */

extern int **prtmsgs;   /* in save-core ! */
#define  errreturn(M,V)   { if(**prtmsgs != 0) perror(M) ; return(V); }

/* Initial Shell Environnement (for restore-core BSD) */
extern char **envpini;

#define round(x,s) ((((x)-1) & ~((s)-1)) +(s))

extern int selfcore;

#define SIZEBUF 1024

/* ALL MACROS ARE IN <a.out.h> */

/**********************************************************
                Save-core en mode EXECORE
***********************************************************/

struct exec entete, templatentete;
char corbuf[SIZEBUF];

extern int errno;

int corsav (nom) char *nom; {
int fd, fdbin, realfdbin;
int size_header = sizeof(struct exec);
long bout;
long n, wr, control;

        llglobb("","",-1);                /* pour tuer un sous-sh */

        /* positionne les variables pour le restore-core */
        corscons = scons;
        corbtbin = btbin;
        corstbin = stbin;

        selfcore = 1;  /* un EXECORE identifiable a l'execution */

        if((fdbin = open(lelispbin, 0)) == -1)
          errreturn(lelispbin, 1);

        if((realfdbin = open(realbin, 0)) == -1)
          errreturn(realbin, 1);

        if((fd = creat(nom, 0777)) /* rwxrwxrwx | umask */
	    == -1){
                if(errno != ETXTBSY) 
                        errreturn(nom, 1);
                if(unlink(nom) == -1)
                        errreturn(nom, 1);
                if((fd = creat(nom, 0777)) /* rwxrwxrwx | umask */
		   == -1)
                        errreturn(nom, 1);
        }

/* lecture du header du binaire qui tourne en memoire */ 
/******************************************************/
/*        control=lseek(realfdbin, 0, 0);
        if (control != 0)
           { perror ("save-core0"); exit(1); } */
        control=read(realfdbin, &entete, sizeof (struct exec));
        if (control != sizeof (struct exec))
           { perror ("save-core1"); exit(1); }

/* lecture du header du template */
/*********************************/
        control=read(fdbin, &templatentete, sizeof (struct exec));
        if (control != sizeof (struct exec))
           { perror ("save-core3"); exit(1); }

        if((bout = (long) sbrk(0)) == -1)
	  { perror ("save-core4"); exit(1); }

/* initialisation du header de "nom" */
/*************************************/

        entete.a_data = bout - N_DATADDR(entete);
        entete.a_syms = templatentete.a_syms; 
        entete.a_bss = 0;
        entete.a_trsize = 0;
        entete.a_drsize = 0;
	entete.a_magic = ZMAGIC;

/* ecriture du header */
/**********************/
        control=write(fd, &entete, size_header);
        if (control != size_header)
	   { perror ("save-core6"); exit(1); }

/* recopie du texte */
/********************/
        control=lseek(realfdbin, size_header , 0);
        if (control != size_header)
           { perror ("save-core7"); exit(1); }
        control=lseek(fd, size_header, 0);
        if (control != size_header)
           { perror ("save-core8"); exit(1); }

/* in ZMAGIC, the size_header is include in size_text, so -> */
	n = entete.a_text - size_header;
	while (n >= SIZEBUF) {
	    control=read(realfdbin, corbuf, SIZEBUF);
            if (control != SIZEBUF)
	       { perror ("save-core9"); exit(1); }
	    wr=write(fd, corbuf, SIZEBUF);
	    if (wr != SIZEBUF) { perror ("save-core10"); exit(1); }
	    n -= SIZEBUF;
            }
	    control=read(realfdbin, corbuf, n);
            if(control != n) { perror ("save-core11"); exit(1); }
	    wr=write(fd, corbuf, n);
	    if(wr != n) { perror ("save-core12"); exit(1); }

/* recopie de la zone data (on la prend en memoire) */
/****************************************************/
        control=lseek(fd, N_DATOFF(entete),0);
        if(control != N_DATOFF(entete))
          { perror ("save-core11"); exit(1); }
        control=write(fd, N_DATADDR(entete), entete.a_data);
        if(control != entete.a_data)
	  { perror ("save-core12"); exit(1); }

/* recopie de la zone symbol du template */
/*****************************************/
        control=lseek(fdbin, N_SYMOFF(templatentete), 0);
        if (control != N_SYMOFF(templatentete))
	       { perror ("save-core13"); exit(1); }

        control=lseek(fd, N_SYMOFF(entete), 0);
        if (control != N_SYMOFF(entete))
	       { perror ("save-core14"); exit(1); }

        while ((n = read(fdbin, corbuf, SIZEBUF)) > 0) {
              control=write(fd, corbuf, n);
              if (control != n)
	      { perror ("save-core15"); exit(1); } 
        }

        close(realfdbin);
        close(fdbin);
        close(fd);

        return(0);
}

/**********
   Restore-core en mode EXECORE
***********/
extern unix_stty();

char *corargv[3] = { "lelispbin", "003", 0};

int corest (nom) char *nom; {
int fd, i;
	corargv[0] = nom;		/* convention Unix */
        if ((fd = open(nom, 0)) == -1)
		errreturn(nom, 1);
        close(fd);
        unix_stty(); /* on passe en stty unix pour en heriter
                        dans le restore-core */
        sprintf(corargv[1], "%d", scons/(8*8*1024));
        execve(nom, corargv, envpini);
        errreturn (nom, 1);
}


