The most common predefined exceptions are:
system
\begin{caml_primitive}
failure : string -> exc
break : exc
io_failure : string -> exc
\end{caml_primitive}
\begin{itemize}
\item \verb"break" is the exception which is raised when CAML receives the
INTERRUPT signal (generally CTRL C).
\item \verb"io_failure" is raised when a failure occurs inside the
 input/output package (e.g. attempt to open a file which does not exist).
\item \verb"failure" is mainly used by the basic functions provided by
the CAML libraries. Informal semantics is that this error is not a
fatal one.
\item \verb"system" is raised when an error occurs in some very primitive
part of the CAML system code (e.g. stack overflow detection, error in
floating point routines).
\end{itemize}
