\conceptindex{integer}
\conceptindex{\verb"big_int"}

Elements of type \verb"big_int" are arbitrarily large signed numbers. All 
operations on this type are performed with copy update.

We have the following definition of type \verb"big_int":
\begin{small}
\begin{verbatim}
type big_int = { Sign : int; Abs_Value : nat };;
\end{verbatim}
\end{small}

In fact the sign is -1, 0 or 1 according to the classical conventions on signs 
as follows with generical writing: 
\begin{small}
\begin{verbatim}
let sign (x) = 
  when x<0 -> -1 
     | x=0 -> 0 
     |  _  -> 1
;;
\end{verbatim}
\end{small}

You cannot create a \verb"big_int" with a sign different from -1, 0 and 1.
The sign is supposed to correspond to the real sign of the number and 
particularly that the equivalence 
$$
sign(x)=0 \Longleftrightarrow x=0
$$
%                         sign(x) = 0 <==> x = 0
is always respected.
It is advisable not to introduce a \verb"big_int" violating this
convention by directly typing in such a record.
