\begin{caml_primitive}
normalize_ratio : ratio -> ratio
get_normalize_ratio : unit -> bool
set_normalize_ratio : bool -> bool
cautious_normalize_ratio : ratio -> ratio
get_normalize_ratio_when_printing : unit -> bool
set_normalize_ratio_when_printing : bool -> bool
cautious_normalize_ratio_when_printing : ratio -> ratio
is_normalized_ratio : ratio -> bool
\end{caml_primitive}

Normalization is adaptable. Two flags allow you to choose when you want
to normalize rational numbers: after each computation, only before
printing, or never. You can set or consult them with the 
\verb"(g|s)et_normalize_ratio{_when_printing}" functions.
For more information see chapter~\ref{numdir}.

To force the normalization of a particular rational number, use the 
normalization primitive \verb"normalize_ratio".

On the other hand, if you want the normalization to be performed only if one of
these flags is turned on, use \verb"cautious_normalize_ratio" or 
\verb"cautious_normalize_ratio_when_printing".

When the \verb"Normalized" label of a \verb"ratio" is set to
\verb"true", normalization is not performed anymore on this number. So
the gcd of the numerator and denominator of a rational number is
computed at the most once. \verb"is_normalized_ratio r" tells you if
the rational number \verb"r" is already normalized. 
