\begin{caml_primitive}
sqrt_big_int : big_int -> big_int
power_int_positive_int : int * int -> big_int
power_int_positive_big_int : int * big_int -> big_int
base_power_big_int : int * int * big_int -> big_int
power_big_int_positive_int : big_int * int -> big_int
power_big_int_positive_big_int : big_int * big_int -> big_int
\end{caml_primitive}

\verb"sqrt_big_int bi" computes the integer part of the square root 
of the \verb"big_int" \verb"bi".

\verb"power_int_positive_int (i1, i2)" yields the \verb"big_int"
resulting from the computation of $i1^{i2}$ where $i1$ and $i2$ are
\verb"int"s and $i2 \geq 0$. 

\verb"power_int_positive_big_int (i, bi)" yields the \verb"big_int"
resulting from the computation of $i^{bi}$ where $bi$ is a positive
\verb"big_int". 

\verb"base_power_big_int (base, n, bi)" computes $bi \times base^n$ as far as 
it is an integer.

\verb"power_big_int_positive_int (bi, i)" yields the \verb"big_int"
resulting from the computation of $bi^{i}$ where $i$ is a positive \verb"int". 

\verb"power_big_int_positive_big_int(bi1, bi2)" yields the
\verb"big_int" resulting from the computation of $bi1^{bi2}$ where
$bi2$ is a positive \verb"big_int". 

\exple
\begin{small}
\begin{verbatim}
#sqrt_big_int #(1e10);;
#(100000) : big_int

#power_int_positive_int (#10, #11);;
#(100000000000) : big_int

#power_int_positive_big_int (#10, #(11));;
#(1215752192) : big_int

#base_power_big_int (#10, #2, #(12));;
#(1200) : big_int

#base_power_big_int (#10, #-2, #(1.2e3));;

Evaluation Failed: failure "base_power_big_int"

#base_power_big_int (#10, #-1, #(12));;

Evaluation Failed: failure "base_power_big_int"

#power_big_int_positive_int (#(10), #11);;
#(100000000000) : big_int

#power_big_int_positive_big_int (#(10), #(11));;
#(100000000) : big_int
\end{verbatim}
\end{small}
