\begin{caml_primitive}
num_bits_int : int -> int
num_decimal_digits_int : int -> int
power_int : int * int -> int
power_int_positive_int : int * int -> big_int
\end{caml_primitive}
\conceptindex{\verb"**"}

\verb"num_bits_int i" (resp. \verb"num_decimal_digits_int i") is the 
number of digits of the binary (resp. decimal) representation of \verb"i".

\verb"power_int (i, n)" (resp. \verb"power_int_positive_int (i, n)") is the 
\verb"int" (resp. \verb"big_int") representation of $i^n$, with n any
positive or null \verb"int". 

In fact, as long as the result is an integer \verb"power_int" doesn't fail.
\bigskip

\exple
\begin{small}
\begin{verbatim}
#num_bits_int #20;;
5 : int

#num_decimal_digits_int #20;;
2 : int

#power_int (#2, length_of_int);;
-32768 : int

#power_int (#2, succ_int length_of_int);;
0 : int

#power_int_positive_int (#2, length_of_int);;
#(32768) : big_int

#power_int_positive_int (#2, succ_int length_of_int);;
#(65536) : big_int

#power_int (#-1, #-2);;
1 : int
\end{verbatim}
\end{small}
