\begin{caml_primitive}
land_int : int * int -> int
lor_int : int * int -> int
lxor_int : int * int -> int
lshift_int : int * int -> int
lnot_int : int -> int
\end{caml_primitive}
These are ``logical'' functions which operate on numbers {\em bitwise} without
modification of the  arguments. All these  functions are expanded on the fly
into one or a few lines of assembly code.

Their meaning is:
\begin{description}
\item [land\_int:] The nth bit of \verb"land_int (n1,n2)" has value 1
if and only if the nth bit of \verb"n1" and the one of \verb"n2" have
both value 1, else 0. 

\exple
\begin{small}
\begin{verbatim}
#land_int (#2, #4);;
0 : int

#land_int (#3, #8);;
0 : int
\end{verbatim}
\end{small}

For instance to find if a number is a power of 2, you may define
\begin{small}
\begin{verbatim}
#let is_power2 n = (n = land_int (n, -n)) ;;
Value is_power2 is <fun> : int -> bool

#is_power2 #4;;
true : bool

#is_power2 #3;;
false : bool
\end{verbatim}
\end{small}
\item [lor\_int:] The nth bit of \verb"lor_int (n1,n2)" has value 0 if
and only if the nth bit of \verb"n1" and the one of \verb"n2" have
both value 0, else 1. 
\item [lxor\_int:] The nth bit of \verb"lxor_int (n1,n2)" has value 0 
if and only if the nth bit of \verb"n1" and the one of \verb"n2" have
different values. 
\item [lshift\_int:] \verb"lshift_int (n1,n2)" has value \verb"n1" 
shifted of \verb"n2" bits.
If \verb"n2" is positive  the shift is done to  the left (towards  the most
significant bits, hence it is a multiplication by $2^{\verb"n2"}$).
If \verb"n2" is negative the shift is done to the right (towards the least 
significant bits, then it is a division by $2^{-\verb"n2"}$).  

Using \verb"lshift_int" you may extract a bit field from an integer 
representation, as in:
\begin{small}
\begin{verbatim}
#let extract n i = lshift_int (land_int (n, lshift_int (#1,i)), -i);;
Value extract is <fun> : int -> int -> int

#map (extract #24) (interval #0 #15);;
[0; 0; 0; 1; 1; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0; 0] : int list

#map (extract (#-24)) (interval #0 #15);;
[0; 0; 0; 1; 0; 1; 1; 1; 1; 1; 1; 1; 1; 1; 1; 1] : int list
\end{verbatim}
\end{small}
\item [lnot\_int:] A bit of \verb"lnot_int (n)" has value 0 iff the
corresponding bit of \verb"n" has value 1, else 1.
\end{description}
