\begin{caml_primitive}
pred_int : int -> int
succ_int : int -> int
monster_int : int
\end{caml_primitive}
\conceptindex{\verb"pred"}
\conceptindex{\verb"succ"}

\verb"pred_int n" (resp.  \verb"succ_int n") is a primitive equivalent to 
\verb"n-1" (resp.  \verb"n+1"). 
\bigskip

\verb"pred_int least_int" and \verb"succ_int biggest_int" have the same value 
\verb"monster_int". 

\verb"pred_int monster_int" is \verb"biggest_int" 
and \verb"succ_int monster_int" is \verb"least_int".

The lexical convention for type \verb"int" will be presented later in
this chapter (section~\ref{lexconvint}) but the essential thing to
understand the following example is that elements of type \verb"int"
are preceded by a \verb"#". 

\exple
\begin{small}
\begin{verbatim}
#pred_int #1;;
0 : int

#pred_int #0;;
-1 : int

#pred_int least_int;;
-32768 : int

#pred_int biggest_int;;
32766 : int

#pred_int monster_int;;
32767 : int

#succ_int #1;;
2 : int

#succ_int #0;;
1 : int

#succ_int least_int;;
-32766 : int

#succ_int biggest_int;;
-32768 : int

#succ_int monster_int;;
-32767 : int
\end{verbatim}
\end{small}
