Exceptions give way to handle unusual or erroneous programming situations.
Moreover, exception handling is powerful enough to be worth using it as a 
regular programmer tool.

\section{Overview}
\paragraph\ 
\label{exceptions}
Apart from values and types, the basic notions of {\em exceptions}
and exceptional values
 are used to control the way computation runs. One can think of
 exceptional values as signals which are sent, and which may be received by
 functions. Sending is performed by the \kwd{raise} construct and
receiving by the \kwd{try} \ldots \kwd{with} \ldots construct.

Exceptions are typechecked, and thus have to be declared:
\begin{small}
\begin{verbatim}
#exception Failure of string;;
Exception Failure of string is defined
\end{verbatim}
\end{small}
Now the exception \verb"Failure" can be raised:
\begin{small}
\begin{verbatim}
#raise (Failure "uncaught");;

Uncaught exception: (Failure "uncaught")
\end{verbatim}
\end{small}
and trapped:
\begin{small}
\begin{verbatim}
#try raise (Failure "uncaught")
#with Failure "uncaught" -> 1;;
1 : int
\end{verbatim}
\end{small}
The \kwd{with} part of a \kwd{try} \ldots \kwd{with} is just an ordinary
match on exceptional values.

\section{Exceptional values}

Exceptions are constructors of a predefined type \verb"exc":
\begin{small}
\begin{verbatim}
#failure;;
<fun> : string -> exc
\end{verbatim}
\end{small}
exceptional values (that is values of type \verb"exc") are thus regular values
with the additional property that they can be raised, since we get a 
predefined operator \kwd{raise} which requires exceptional values as argument.

\begin{small}
\begin{verbatim}
#let my_exceptional_value = failure "poi";;
Value my_exceptional_value is (failure "poi") : exc

#raise my_exceptional_value;;

Evaluation Failed: failure "poi"
\end{verbatim}
\end{small}

Similarly they can be caught using the following constructs:

\section{Exception handling}

\subsection{The try \ldots with \ldots construct}

The idea is to try to evaluate an expression and simultaneously to provide a
way to catch exceptional values that may be raised during this evaluation.

\noindent
\syncat{Try \ldots with \ldots construct}\\
\begin{tabular}{lrl}
 & \affect & \kwd{try} \syncat{expression} \kwd{with} \syncat{matching}
\end{tabular}

Semantics:
\kwd{try} e1 \kwd{with} \syncat{matching} returns the value of e1 if e1
 evaluates normally. If an exceptional value is raised (during the evaluation
of e1), then this exceptional value is matched with the clauses of
 \syncat{matching}, and as usual the expression part of the selected clause
is returned. When the match fails the exceptional value is propagated.

\subsection*{Typechecking of exceptions}

\begin{itemize}
\item \kwd{raise} \syncat{expression}: has fully polymorphic type
 $\alpha$ as soon as \syncat{expression} has type $exc$.
\item \kwd{try} \syncat{expression} \kwd{handle} \kwd{with} \syncat{handler}:
if $ty$ is the type of \syncat{expression} the whole construct has type
$ty$ provided that \syncat{handler} has type $exc \rightarrow ty$.
\end{itemize}
