\begin{caml_primitive}
div_digit_nat : nat * int * nat * int * nat * int * int * nat * int -> int
div_nat : nat * int * int * nat * int * int -> unit
shift_right_nat : nat * int * int * nat * int * int -> unit
gcd_int_nat : int * nat * int * int -> int
gcd_nat : nat * int * int * nat * int * int -> int
\end{caml_primitive}
\subsubsection{Division of a natural number by a digit}
\verb"div_digit_nat (quo, offq, rem, offr, nat1, off1, len1, nat2, off2)" 
divides subnat \linebreak $nat1_{off1, len1}$ by digit $nat2_{off2}$,
places the quotient in subnat $quo_{offq,len1-1}$ and the remainder in
digit $rem_{offr}$. 

More formally speaking \verb"div_digit_nat" satisfies the following equation :

\begin{eqnarray*} 
\sum_{i=0}^{i < len1} nat1_{off1+i} \, B^i = 
\left( \sum_{i=0}^{i < len1-1} quo_{offq+i} \, B^i \right) \times nat2_{off2} 
+ rem_{offr} 
\end{eqnarray*}
%                         /                       \
% i < len1                | i < len1-1            |
% --------                | ----------            |
%  \                  i   |  \                  i |
%   )      nat1      B  = |   )      quo       B  |  nat2      + rem
%  /           off1+i     |  /          offq+i    |      off2       offr
% --------                | ----------            |
%   i = 0                 |  i = 0                |
%                         \                       /


with $0 \leq rem_{offr} < nat2_{off2}$.

\verb"div_digit_nat" implies $len1 > 1$, $nat1_{off1+len1-1} <
nat2_{off2}$ and $length\_nat (quo) \geq off1+len1-1$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#div_digit_nat (nat, #0, nat, #2, nat, #0, #3, nat, #3);;
3 : int

#debug_print_nat nat;;
|00000003|00000000|AAAAAAAB|00000000|() : unit

#div_digit_nat (nat, #0, nat, #2, nat, #0, #3, nat, #3);;
3 : int

#debug_print_nat nat;;
|00000003|00000000|38E38E39|00000000|() : unit

#div_digit_nat (nat, #0, nat, #2, nat, #0, #3, nat, #3);;
3 : int

#debug_print_nat nat;;
|00000003|00000002|12F684BD|AAAAAAAA|() : unit

#div_digit_nat (nat, #0, nat, #2, nat, #1, #2, nat, #0);;
0 : int

#debug_print_nat nat;;
|00000003|12F684BF|12F684BD|00000003|() : unit
\end{verbatim}
\end{small}

\subsubsection{Division of natural numbers}
\verb"div_nat (nat1, off1, len1, nat2, off2, len2)" divides subnat
$nat1_{off1, len1}$ by subnat $nat2_{off2, len2}$, places the quotient
in the subnat $nat1_{off1+len2, len1-len2}$ and the remainder in
subnat $nat1_{\verb"off1, len2"}$. 

More formally speaking \verb"div_nat" verifies the following equation : 
\begin{eqnarray*}
\lefteqn{\sum_{i=0}^{i < len1} nat1_{off1+i} \, B^i=}\\
& & \left(\sum_{i=0}^{i < len1 - len2} nat'_{off1+len2+i} \, B^i \right)
\times \left(\sum_{i=0}^{i < len2} nat2_{off2+i} \, B^i \right) +
\left(\sum_{i=0}^{i < len2} nat'_{off+i}\, B^i \right) 
\end{eqnarray*}
%                 /                       \
%                 | i < len1              |
%                 | --------              |
%                 |  \                  i |
% nat1          = |   )      nat1      B  | =
%     off1,len1   |  /           off1+i   |
%                 | --------              |
%                 |  i = 0                |
%                 \                       /
%         /                                   \   /                       \
%         | i < len1 - len2                   |   | i < len2              |  
%         | ---------------                   |   | --------              |
%         |  \                              i |   |  \                  i |    
%         |   )             nat'           B  | * |   )      nat2      B  |
%         |  /                  off1+len2+i   |   |  /          off2+i    |
%         | ---------------                   |   | --------              |  
%         |      i = 0                        |   |  i = 0                |
%         \                                   /   \                       /
%
%         /                        \
%         | i < len2               |
%         | --------               |
%         |  \                   i |
%       + |   )       nat'      B  | 
%         |  /           off1+i    |   
%         | --------               |
%         |  i = 0                 |
%         \                        /

with 
\begin{eqnarray*} 
0 \leq \sum_{i=0}^{i < len2} nat'_{off1+i} \, B^i 
< \sum_{i=0}^{i < len2} nat2_{off1+i}.  
\end{eqnarray*}
%                     i < len2                i < len2  
%                     --------                --------
%                      \                  i    \
%                0 <=   )      nat'      B  <   )       nat2       .
%                      /          off1+i       /            off1+i
%                     --------                --------
%                      i = 0                   i = 0  

\verb"div_nat" replaces each digit $nat1_{off1+i}$ with its equivalent
digit $nat'_{off1+i}$. This implies $len1 \geq len2$ and
$nat1_{off1+len1-1} < nat2_{off2+len2-1}$.  

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #5;;
Value nat is #<0> : nat

#for i = #0 to #4 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000004|00000003|00000002|00000001|00000000|() : unit

#div_nat (nat, #0, #3, nat, #3, #2);;
() : unit

#debug_print_nat nat;;
|00000004|00000003|7FFFFFFF|00000003|80000003|() : unit
\end{verbatim}
\end{small}

\subsubsection{Shifting right natural numbers}
\verb"shift_right_nat (nat1, off1, len1, nat2, off2, shift)" shifts right 
each digit of \linebreak $nat1_{off1, len1}$. The $shift$ bits out of
any digit replace the $shift$ free bits of the previous digit.  
$shift$ zeros replace the $shift$ free bits of the last digit and the most
significant bits of digit $nat2_{off2}$ get back the $shift$ bits
out of the first digit. 
So \verb"shift_right_nat" divides $nat1_{off1, len1}$ by $2^{shift}$.  

More formally speaking \verb"shift_right_nat" verifies the following equation~:

\begin{eqnarray*} 
\sum_{i=0}^{i < len1} nat1_{off1+i} \, B^i = 
2^{shift}\,\left(nat2'_{off2} \, B^{-1} 
+ \sum_{i=0}^{i < len1} \verb"nat1'"_{off1+i} \,B^i \right). 
\end{eqnarray*}
%                                   /                                         \
%   i < len1                        |                 i < len1                |
%   --------                        |                 --------                |
%    \                   i    shift |            -1    \                    i |
%     )      nat1       B  = 2      | nat2'     B   +   )      nat1'       B  |.
%    /           off1+i             |      off2        /           off1+i     |
%   --------                        |                 --------                |
%    i = 0                          |                   i = 0                 |
%                                   \                                         /

\verb"shift_right_nat" replaces each digit $nat1_{off1+i}$ with its
equivalent digit $\verb"nat1'"_{off1+i}$ and $nat2_{off2}$ with
$\verb"nat2'"_{off2}$.  This implies $0 \leq shift < length\_of\_digit$. 
For speed, the case $shift=0$ is explicitly tested.  

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#shift_right_nat (nat, #1, #3, nat, #0, #8);;
() : unit

#debug_print_nat nat;;
|00000000|03000000|02000000|01000000|() : unit

#shift_right_nat (nat, #1, #3, nat, #0, #16);;
() : unit

#debug_print_nat nat;;
|00000000|00000300|00000200|00000000|() : unit

#shift_right_nat (nat, #1, #3, nat, #0, #16);;
() : unit

#debug_print_nat nat;;
|00000000|00000000|03000000|02000000|() : unit
\end{verbatim}
\end{small}

\subsubsection{Greatest common divisor between an \protect\verb"int"
and a \protect\verb"nat"} 

\verb"gcd_int_nat (i, nat, off, len)" computes the gcd of ``small''
int $i$ and subnat $nat_{off, len}$ and puts it in digit $nat_{off}$. 
If $i=0$ then the resulting value of the function is 1 and digit $nat_{off}$ is
unchanged, else the resulting value of the function is 0 and the gcd is placed 
in digit $nat_{off}$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #2;;
Value nat is #<0> : nat

#set_digit_nat (nat, #0, #3);
#set_digit_nat (nat, #1, #2);
#debug_print_nat nat;;
|00000002|00000003|() : unit

#gcd_int_nat (#10, nat, #0, #2);;
0 : int

#debug_print_nat nat;;
|00000002|00000005|() : unit
\end{verbatim}
\end{small}
\subsubsection{Greatest common divisor between natural numbers}

\verb"gcd_nat (nat1, off1, len1, nat2, off2, len2)" places the gcd 
of subnats $nat1_{off1, len1}$ and $nat2_{off2, len2}$ in $nat1_{off1, len}$
where $len$ is the resulting value of \verb"gcd_nat". 
$len2$ can be smaller than $len1$ unless subnat $nat1_{off1, len1}$ is null.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #3;;
Value nat is #<0> : nat

#for i = #0 to #2 do set_digit_nat (nat, i, i) done;
#debug_print_nat nat;;
|00000002|00000001|00000000|() : unit

#let len = gcd_nat (nat, #0, #3, nat, #0, #2);;
Value len is 2 : int

#debug_print_nat (copy_nat (nat, #0, len));;
|00000001|00000000|() : unit
\end{verbatim}
\end{small}
