\begin{caml_primitive}
create_ratio : big_int * big_int -> ratio
create_normalized_ratio : big_int * big_int -> ratio
\end{caml_primitive}

We present here only the primitive functions to create a number of
type \verb"ratio": you can of course create a \verb"ratio" with
coercion functions or using lexical convention. 

\verb"create_ratio (num, den)" creates the \verb"ratio" with numerator 
(resp. denominator) equal to \verb"num" (resp. \verb"den"), set up the
sign of the rational number, verifies if its denominator is not null
if necessary, normalizes this rational if normalization during
computing is requested and sets \verb"Normalized" label with the value
of this normalization flag. 

\verb"create_normalized_ratio (num, den)" creates the \verb"ratio"
with numerator (resp. denominator) equal to \verb"num" (resp.
\verb"den"), reports the eventual sign of \verb"den" on the numerator
of the created \verb"ratio", verifies if denominator is not null when
null denominators are prohibited and sets \verb"Normalized" label with
{\em true}. It is interesting to use this creation function when you
are sure a rational number to be already normalized, since this
\verb"ratio" will be no more normalized, but off course you must be right.

By default null denominators are prohibited. For more information see 
chapter~\ref{numdir}.

\exple
\begin{small}
\begin{verbatim}
#create_ratio (#(2), #(3));;
#[2/3] : ratio

#create_ratio (#(2), #(-3));;
#[-2/3] : ratio

#create_ratio (#(4), #(6));;
#[2/3] : ratio

#create_ratio (#(1), #(0));;

Evaluation Failed: failure "create_ratio infinite or undefined rational number"

#create_normalized_ratio (#(4), #(-6));;
#[-4/6] : ratio
\end{verbatim}
\end{small}
