\begin{caml_primitive}
eq_big_int_ratio : big_int * ratio -> bool
compare_big_int_ratio : big_int * ratio -> int
lt_big_int_ratio : big_int * ratio -> bool
le_big_int_ratio : big_int * ratio -> bool
gt_big_int_ratio : big_int * ratio -> bool
ge_big_int_ratio : big_int * ratio -> bool
eq_ratio : ratio * ratio -> bool
compare_ratio : ratio * ratio -> int
lt_ratio : ratio * ratio -> bool
le_ratio : ratio * ratio -> bool
gt_ratio : ratio * ratio -> bool
ge_ratio : ratio * ratio -> bool
sign_ratio : ratio -> int
report_sign_ratio : ratio * big_int -> big_int
abs_ratio : ratio -> ratio
min_ratio : ratio * ratio -> ratio
max_ratio : ratio * ratio -> ratio
\end{caml_primitive}
\conceptindex{\verb"<="}
\conceptindex{\verb"="}
\conceptindex{\verb">="}
\conceptindex{\verb"<"}
\conceptindex{\verb">"}
\conceptindex{\verb"max"}
\conceptindex{\verb"min"}
\conceptindex{\verb"abs"}

\verb"lt_ratio", \verb"le_ratio", \verb"gt_ratio", \verb"ge_ratio" 
(resp. \verb"lt_big_int_ratio", \verb"le_big_int_ratio", 
\verb"gt_big_int_ratio", \verb"ge_big_int_ratio") are arithmetic comparisons 
corresponding respectively to \verb"<", \verb"<=", \verb">", \verb">=" between 
elements of type \verb"ratio" (resp. element of type \verb"big_int" and 
\verb"ratio").

The primitive function for these functions is \verb"compare_ratio" 
(resp. \verb"compare_big_int_ratio"), that is semantically equivalent to:
\begin{small}
\begin{verbatim}
let compare_ratio (r1, r2) =
 when (r1 = r2) -> #0
    | (r1 < r2) -> #-1
    |     _     -> #1

and compare_big_int_ratio (bi, r) =
 when (bi = r) -> #0
    | (bi < r) -> #-1
    |     _     -> #1
;;
\end{verbatim}
\end{small}

\verb"sign_ratio" is equivalent to:
\begin{small}
\begin{verbatim}
let sign_ratio r = sign_big_int r.Numerator ;;
\end{verbatim}
\end{small}

\verb"report_sign_ratio (bi, r)" transfers the sign of the \verb"big_int" 
\verb"bi" on the rational number \verb"r". 

\verb"abs_ratio r" is the absolute value of the rational number \verb"r".

\verb"max_ratio (r1, r2)" and \verb"min_ratio (r1, r2)" are respectively
the greater one and the smaller one of rational numbers \verb"r1" and 
\verb"r2".

\exple
\begin{small}
\begin{verbatim}
#compare_ratio (#[1.2e3],#[12e2]);;
0 : int

#compare_big_int_ratio (#(1.2e3),#[1200/1]);;
0 : int

#compare_big_int_ratio (#(1.2e3),#[12e2]);;
0 : int
\end{verbatim}
\end{small}
