\begin{caml_primitive}
add_int_big_int : int * big_int -> big_int
add_big_int : big_int * big_int -> big_int
minus_big_int : big_int -> big_int
sub_big_int : big_int * big_int -> big_int
mult_int_big_int : int * big_int -> big_int
mult_big_int : big_int * big_int -> big_int
square_big_int : big_int -> big_int
quomod_big_int : big_int * big_int -> big_int * big_int
quo_big_int : big_int * big_int -> big_int
div_big_int : big_int * big_int -> big_int
mod_big_int : big_int * big_int -> big_int
gcd_big_int : big_int * big_int -> big_int
\end{caml_primitive}
\conceptindex{\verb"+"}
\conceptindex{\verb"-"}
\conceptindex{\verb"*"}
\conceptindex{\verb"/"}
\conceptindex{\verb"gcd"}

\verb"add_big_int", \verb"sub_big_int", \verb"mult_big_int" perform
respectively the addition, subtraction and multiplication on \verb"big_int"s. 

\verb"add_int_big_int (i, bi)" and \verb"mult_int_big_int (i, bi)" perform
respectively the addition and multiplication between the \verb"int"
$i$ and the \verb"big_int" $bi$ and yield a \verb"big_int". 

\verb"minus_big_int bi" is the opposite of \verb"bi".

\verb"square_big_int bi" computes the square of the \verb"big_int"
\verb"bi" faster than multiplication in the manner of \verb"square_nat". 

\verb"quomod_big_int (bi1, bi2)" is the pair of the quotient and the remainder 
of the Euclidian division of \verb"bi1" by \verb"bi2".

These two results may be consulted separately with \verb"quo_big_int" (or 
\verb"div_big_int" which is exactly the same function) and \verb"mod_big_int" 
respectively. 

\verb"gcd_big_int (bi1, bi2)" computes the gcd of the two
\verb"big_int"s \verb"bi1" and \verb"bi2". This gcd is always positive
or null. 

\exple
\begin{small}
\begin{verbatim}
#minus_big_int (big_int_of_int biggest_int);;
#(-32767) : big_int

#minus_big_int (big_int_of_int least_int);;
#(32767) : big_int

#minus_big_int (big_int_of_int monster_int);;
#(32768) : big_int

#mult_int_big_int (#2, big_int_of_int biggest_int);;
#(65534) : big_int

#quomod_big_int (#(123), #(3));;
(#(41),#(0)) : big_int * big_int

#quomod_big_int (#(123), #(-3));;
(#(-41),#(0)) : big_int * big_int
\end{verbatim}
\end{small}
