\begin{caml_primitive}
approx_num_fix : int * num -> string
approx_num_exp : int * num -> string
float_num : num -> num
\end{caml_primitive}

\verb"approx_num_fix (n, r)" approaches the rational number \verb"n" with a 
\verb"n" 10-digits fix point representation. This is an odd function and the 
last digit is round off. In an informal manner, the printing format is:
\begin{small}
\begin{verbatim}
integer_part . decimal_part_with_n_digits
\end{verbatim}
\end{small}

\verb"approx_num_exp (n, r)" approaches the rational number \verb"n" with a
\verb"n" 10-digits floating point representation. This is an odd function and 
the last digit is round off. In an informal manner, the printing format is:
\begin{small}
\begin{verbatim}
(+|-) (0. n_first_digits e msd) | (1. n_zeros e (msd+1))
\end{verbatim}
\end{small}

\verb"float_num" is equivalent to:
\begin{small}
\begin{verbatim}
let float_num n = num_of_float (float_of_num n)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#approx_num_fix (#12, #{1.2e3/1.1e2});;
"+10.909090909091" : string

#approx_num_fix (#-1, #{1.2e3/1.1e2});;
"+1" : string

#approx_num_fix (#10, #{355/113});;
"+3.1415929204" : string

#approx_num_exp (#12, #{1.2e3/1.1e2});;
"+0.109090909091e2" : string

#approx_num_exp (#2, #{1.2e3/1.1e2});;
"+0.11e2" : string

#approx_num_exp (#10, #{355/113});;
"+0.3141592920e1" : string

#float_num #{1.2e3/1.1e2};;
#{1090909/100000} : num
\end{verbatim}
\end{small}
