\begin{caml_primitive}
incr_nat : nat * int * int * int -> int
add_nat : nat * int * int * nat * int * int * int -> int
\end{caml_primitive}
\subsubsection{Incrementing natural numbers}
\verb"incr_nat (nat, off, len, c_in)" adds in place the carry in 
$c\_in$ ($c\_in=0$ or $c\_in=1$) to the subnat  $nat_{off, len}$ and 
returns the carry out $c\_out$. 

More formally speaking \verb"incr_nat" performs the following operation :
\begin{eqnarray*}
\lefteqn{nat_{off, len} + c\_in =} \\
& & \left(\sum_{i=0}^{i<len} nat_{off+i}\, B^i \right) 
+ c\_in = \\
& & \left(\sum_{i=0}^{i<len} nat'_{off+i}\, B^i \right) 
+ c\_out\, B^{len}.
\end{eqnarray*}
%                      /                    \     
%                      | i < len            |         
%                      | -------            |         
%                      |  \               i |         
% nat         + c_in = |   )     nat     B  | + c_in  
%    off, len          |  /         off+i   |         
%                      | -------            |         
%                      |  i = 0             |        
%                      \                    /
%                         
%                      /                      \
%                      | i < len              |
%                      | -------              |
%                      |  \                 i |          len
%                    = |   )      nat'     B  | + c_out B    .
%                      |  /          off+i    |   
%                      | -------              |
%                      |  i = 0               |
%                      \                      /

\verb"incr_nat" replaces each digit $nat_{off+i}$ with its 
equivalent digit $nat'_{off+i}$ and returns the carry out 
$c\_out$, with value 0 or 1. 

$c\_out=1$ if and only if $nat_{off, len}=B^{len}-1$ and $c\_in=1$. 
\verb"len" may be null, so the carry out equals the carry in.

\exple
\begin{small}
\begin{verbatim}
#let nat = make_nat #4;;
Value nat is #<0> : nat

#complement_nat (nat, #0, #4);;
() : unit

#debug_print_nat nat;;
|FFFFFFFF|FFFFFFFF|FFFFFFFF|FFFFFFFF|() : unit

#incr_nat (nat, #2, #2, #1);;
1 : int

#debug_print_nat nat;;
|00000000|00000000|FFFFFFFF|FFFFFFFF|() : unit

#incr_nat (nat, #0, #3, #1);;
0 : int

#debug_print_nat nat;;
|00000000|00000001|00000000|00000000|() : unit

#incr_nat (nat, #0, #3, #1);;
0 : int

#debug_print_nat nat;;
|00000000|00000001|00000000|00000001|() : unit

#incr_nat (nat, #0, #3, #1);;
0 : int

#debug_print_nat nat;;
|00000000|00000001|00000000|00000002|() : unit
\end{verbatim}
\end{small}

\subsubsection{Addition on natural numbers}
\verb"add_nat (nat1, off1, len1, nat2, off2, len2, c_in)" adds subnats
$nat1_{\verb"off1, len1"}$, $nat2_{\verb"off2, len2"}$ \linebreak and the 
carry in $c\_in$, places result in subnat $nat1_{off1, len1}$
, propagates this carry on subnat $nat1_{off1+len2,\;len1-len2}$ 
and returns the carry out $c\_out$.

More formally speaking \verb"add_nat" performs the following operation : 
\begin{eqnarray*}
\lefteqn{nat1_{off1, len1} + nat2_{off2, len2} 
+ $c\_in$ =} \\
& & \left(\sum_{i=0}^{i<len1} nat1_{off1+i} \,B^i \right)
+ \left(\sum_{i=0}^{i<len2} nat2_{off2+i} \,B^i \right) 
+ c\_in =  \\
& & \left(\sum_{i=0}^{i<len1} nat'_{off1+i} \,B^i \right)
 + c\_out \,B^{len1}.
\end{eqnarray*}
%
% nat1         + nat2          + c_in =
%    off1, len1      off2, len2         
%                         
%        /                       \   /                       \
%        | i < len1              |   | i < len2              |  
%        | --------              |   | --------              | 
%        |  \                  i |   |  \                  i |       
%        |   )      nat1      B  | + |   )      nat2      B  | + c_in =
%        |  /           off1+i   |   |  /          off2+i    |
%        | --------              |   | --------              |   
%        |  i = 0                |   |  i = 0                |
%        \                       /   \                       /
%
%        /                        \
%        | i < len1               |
%        | --------               |
%        |  \                   i |          len1
%        |   )       nat'      B  | + c_out B     .
%        |  /           off1+i    |   
%        | --------               |
%        |  i = 0                 |
%        \                        /


\verb"add_nat" replaces each digit $nat1_{off1+i}$ with its 
equivalent digit $nat'_{off1+i}$ and returns the carry out 
$c\_out$, with value 0 or 1. This implies $0 \leq c\_in \leq 1$ 
and $len1 \geq len2$. 

$nat1$ and $nat2$ can be physically the same one under the condition $off1 
\leq off2$. 

If $len2 = 0$, \verb"add_nat (nat1, off1, len1, nat2, off2, len2, c_in)" is
equivalent to \verb"incr_nat (nat1, off1, len1, c_in)".

\exple
\begin{small}
\begin{verbatim}
#let nat1 = nat_of_int #2;;
Value nat1 is #<2> : nat

#add_nat (nat1, #0, #1, nat_of_int #3, #0, #1, #0);;
0 : int

#debug_print_nat nat1;;
|00000005|() : unit

#add_nat (nat1, #0, #1, nat_of_int #3, #0, #1, #1);;
0 : int

#debug_print_nat nat1;;
|00000009|() : unit

#let nat1 = nat_of_int #3;;
Value nat1 is #<3> : nat

#complement_nat (nat1, #0, #1);;
() : unit

#add_nat (nat1, #0, #1, nat_of_int #3, #0, #1, #1);;
1 : int

#debug_print_nat nat1;;
|00000000|() : unit

#let nat1 = create_nat #3;;
Value nat1 is #<0> : nat

#for i = #0 to #1 do set_digit_nat (nat1, i, i) done;
#set_digit_nat (nat1, #2, #0);
#complement_nat (nat1, #0, #2);
#debug_print_nat nat1;;
|00000000|FFFFFFFE|FFFFFFFF|() : unit

#add_nat (nat1, #0, #3, nat1, #1, #1, #0);;
0 : int

#debug_print_nat nat1;;
|00000000|FFFFFFFF|FFFFFFFD|() : unit

#let nat2 = copy_nat (nat1, #0, #3);;
Value nat2 is #<18446744073709551613> : nat

#add_nat (nat1, #0, #2, nat1, #1, #1, #0);;
1 : int

#debug_print_nat nat1;;
|00000000|00000000|FFFFFFFC|() : unit

#add_nat (nat2, #0, #3, nat2, #1, #1, #0);;
0 : int

#debug_print_nat nat2;;
|00000001|00000000|FFFFFFFC|() : unit
\end{verbatim}
\end{small}
