(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                    CAML: users' library                               *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            LIENS                                      *)
(*                        45 rue d'Ulm                                   *)
(*                         75005 PARIS                                   *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* paint.ml        painting  types                                       *)
(*              Emmanuel Chailloux & Guy Cousineau                       *)

module paint;;

type color = Rgb of float * float * float
           | Hsb of float * float * float
           | Gra of float;;

type linecap = Buttcap | Squarecap | Roundcap;;

type linejoin = Beveljoin | Roundjoin | Miterjoin;;

type linestyle = {linewidth:float;
                  linecap:linecap;
                  linejoin:linejoin;
                  dashpattern:int list};;

type fillstyle = Nzfill | Eofill;;
type clipstyle  = Nzclip | Eoclip;;

type graphic_state =
  {!color : color;
   !linewidth:float;
   !linecap:linecap;
   !linejoin:linejoin;
   !dashpattern:int list;
   !fillstyle : fillstyle};;

end  module with
type color
 and linestyle
 and linecap
 and linejoin
 and clipstyle
 and fillstyle
 and graphic_state;;
