(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                    CAML: users' library                               *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            LIENS                                      *)
(*                        45 rue d'Ulm                                   *)
(*                         75005 PARIS                                   *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* circletext.ml caml graphic system interfaces with postscript      *)
(*              Emmanuel Chailloux & Guy Cousineau                       *)

module circletext
using
type point = {xc:float;yc:float};
type transformation;
type font;
type text;
type color = Rgb of float * float * float
           | Hsb of float * float * float
           | Gra of float;
type picture;

value text_width: font -> string -> float;
value make_text_picture: string -> font -> color -> picture;
value translation : float * float -> transformation;
value rotation: point -> float -> transformation;
value CT: transformation * transformation -> transformation;
value transform_picture: transformation -> picture -> picture;
value join_picture_list: picture list -> picture;;

#arith float;;

#pragma infix "CT";;
  
let Pi = acos (-1.0);;

let circletexttop fnt  str ce radius =
  let l= text_width fnt str
  in
    if l >= 2.0*Pi*radius
       then failwith "text is longer than circumference"
       else let start_angle = (Pi/2.0) + l/(2.0*radius)
            and ll= explode str
             in
               let  al = start_angle:: (rev (tl (snd
                        (it_list (fun (a,l) w -> let aa = a-w/radius
                                                 in  (aa, aa::l))
                               (start_angle,[]) 
                               (map (text_width fnt) ll)))))
              and mkp  (s,a) =
                let T1 = rotation ce ((a-Pi/2.0)*180.0/Pi)
                and T2 = translation (ce.xc,ce.yc+radius)
                 in transform_picture (T1 CT T2)
                   (make_text_picture s fnt (Gra 0.0))
                      
              in
                 join_picture_list
                    (map mkp (combine (ll,al)));;

let circletextbottom fnt  str ce radius =
  let l= text_width fnt str
  in
    if l >= 2.0*Pi*radius
       then failwith "text is longer than circumference"
       else let start_angle = (-Pi/2.0) - l/(2.0*radius)
            and ll= explode str
             in
               let  al = start_angle::(rev (tl (snd
                        (it_list (fun (a,l) w -> let aa = a+w/radius
                                                 in  (aa, aa::l))
                               (start_angle,[]) 
                               (map (text_width fnt) ll)))))
              and mkp  (s,a) =
                let T1 = rotation ce ((a+Pi/2.0)*180.0/Pi)
                and T2 = translation (ce.xc,ce.yc-radius)
                 in transform_picture (T1 CT T2)
                   (make_text_picture s fnt (Gra 0.0))
                      
              in
                 join_picture_list
                    (map mkp (combine (ll,al)));;

end module
with
value circletexttop
  and circletextbottom;;

