(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* prelude	Basic functions for the CAML system.			 *)
(*		Group effort.						 *)

#standard arith true
;;

type 'a qbody = qnil | qcons of 'a qcell

and 'a qcell = {mutable Qhead : 'a; mutable Qtail : 'a qbody}
;;

type 'a queue = {mutable Qinsert : 'a qbody; mutable Qbody : 'a qbody}
;;

let enqueue cell = function
    {Qbody=qnil at qb; Qinsert=_ at qi} -> at qi <- at qb <- cell
  | {Qbody=qcons _; Qinsert=(qcons {Qtail=_ at insert; _}) at qi} ->
      at qi <- at insert <- cell
  | _ -> failwith "enqueue"
;;

let dequeue = function
    {Qbody=qnil; _} -> failwith "dequeue"
  | {Qbody=qcons {Qhead=x; Qtail=tl}; _} as queue -> queue.Qbody <- tl;x
;;

type 'a frozen = lazy Freeze of 'a
;;

forward equal : 'a * 'a -> bool
;;

(* 0. Booleans *)
let neg predicate x = not predicate x
;;

(* 1. Numbers *)
let max_integer = num_of_int 32767
;;

let abs_int x = if x >= 0 then x else -x
;;

let abs_float f = if lt_float (f,0.0) then minus_float f else f
;;

let is_int = function Int _ -> true | _ -> false
;;

let is_integer = function
    Int _ -> true | Big_int _ -> true | _ -> false
;;

let int_of_obj = function obj_int i -> i | _ -> failwith "int_of_obj"
and float_of_obj = function
    obj_float f -> f | _ -> failwith "float_of_obj"
;;

let random n = if n > 0 then system_random (0,n) else failwith "random"
and init_random n =
 if n >= 0 then system_srandom n else failwith "init_random"
;;

let pair x y = x,y
;;

let curry f x y = f (x,y) and uncurry f (x,y) = f x y
;;

let f o g = fun x -> f (g x)
;;

let pairing (f,g) (x,y) = f x,g y and distr_pair f (x,y) = f x,f y
and tee (f,g) x = f x,g x
;;

let K x y = x 
and CK x y = y 
and C f x y = f y x 
and W f x = f x x 
and B f g x = f (g x) 
and S f g x = f x (g x)
;;

(* #infix Co;; *)
let f Co g = fun x y -> f (g y) x
;;

let can f x = f x;true ? false
;;

let iterate f = iterate_f
 where rec iterate_f n x =
  if n <= 0 then x else iterate_f (pred n) (f x)
;;

let do_repeat n action arg = repeat_action n
 where rec repeat_action n =
  if n <= 0 then () else (action arg;repeat_action (pred n))
;;

let Y (f:('a -> 'b) -> 'a -> 'b) = g where rec g x = f g x
;;

let rec fix_point f x = if y = x then x else fix_point f y where y = f x
;;

let share f x = try f x with Identity -> x
;;

let pair_share f (x,y) = try f x,share f y with Identity -> x,f y
;;

let share_pair_share f (x,y as pair) =
 try f x,share f y with Identity -> try x,f y with Identity -> pair
;;

let cons x y = x::y
;;

let index x l = index_x (1,l)
 where rec index_x = function
     n,y::l -> if x = y then n else index_x (succ n,l)
   | _ -> failwith "index"
;;

let nth l n = item l (pred n)
;;

let rec rev_append = fun [] -> Id | (x::l') l -> rev_append l' (x::l)
;;

let rev l = rev_append l []
;;

let try_find f = try_find_f
 where rec try_find_f = function
     [] -> failwith "try_find" | h::t -> f h ? try_find_f t
;;

let end_map f default = map_f
 where rec map_f = function [] -> default | a::l -> f a::map_f l
;;

let rev_map f = rev_rec []
 where rec rev_rec acc = function
     [] -> acc | x::l -> rev_rec (f x::acc) l
;;

(* assuming f fails for identity (raising exception Identity)
   extends this property to lists *)
let fun_pair f =
 let rec map_share_f = function
     [] -> raise Identity
   | x::r ->
       try f x::share_map_share_f r with Identity -> x::map_share_f r
 and share_map_share_f = share map_share_f in
  map_share_f,share_map_share_f in
let map_share = fst o fun_pair and share_map_share = snd o fun_pair
;;

let map_i f = map_i_rec
 where rec map_i_rec i = function
     [] -> [] | x::l -> f i x::map_i_rec (i+1) l
;;

let end_map_i f default = map_i_rec
 where rec map_i_rec i = function
     [] -> default | x::l -> f i x::map_i_rec (i+1) l
;;

let map_uncons f (x,L) = f x,map f L
and do_list_uncons f (x,L) = f x;do_list f L
;;

(* it_list f a [b1;...;bn] = (f (...(f a b1)...) bn) *)
let it_list f = it_list_f
 where rec it_list_f a = function
     [] -> a | b::l -> it_list_f (f a b) l
;;

(* fold f a1 [b1; ... ;bn] =
	let a2,c1 = f a1 b1 in
	  ...
	let a,cn = f an bn in
	  a,[c1; ... ;cn]	*)
let fold f = fold_f
 where rec fold_f a1 = function
     [] -> a1,[]
   | b1::bl ->
       let a2,c2 = f a1 b1 in let a,cl = fold_f a2 bl in a,c2::cl
;;

let fold_share f =
 let rec fold_share_f = function
     _,[] -> raise Identity
   | a1,b1::bl ->
       try
        let a2,c2 = f (a1,b1) in
        let a,cl = share_fold_share_f (a2,bl) in a,c2::cl
       with Identity -> let a,cl = fold_share_f (a1,bl) in a,b1::cl
 
 and share_fold_share_f = share fold_share_f in
  fold_share_f
;;

let share_fold_share f =
 let rec fold_share_f = function
     _,[] -> raise Identity
   | a1,b1::bl ->
       try
        let a2,c2 = f (a1,b1) in
        let a,cl = share_fold_share_f (a2,bl) in a,c2::cl
       with Identity -> let a,cl = fold_share_f (a1,bl) in a,b1::cl
 
 and share_fold_share_f = share fold_share_f in
  share_fold_share_f
;;

let do_list_i f = do_list_f
 where rec do_list_f i = function
     [] -> () | x::l -> f i x;do_list_f (succ i) l
;;

let do_list2 f l1 l2 = do_list2_f (l1,l2)
 where rec do_list2_f = function
     [],[] -> ()
   | h1::t1,h2::t2 -> f h1 h2;do_list2_f (t1,t2)
   | _ -> failwith "do_list2"
;;

let l1 @ l2 = if l2 == [] then l1 else append l1 l2
;;

let partition p l = list_it fork l ([],[])
 where fork a (pos,neg) = if p a then a::pos,neg else pos,a::neg
;;

let replicate n =
 if n < 0 then failwith "replicate"
  else fun x -> replicate_aux ([],n)
             where rec replicate_aux = function
                 l,0 -> l | l,n -> replicate_aux (x::l,pred n)
;;

let flat ll = list_it append ll []
;;

let flat_map f = flat_map_f
 where rec flat_map_f = function [] -> [] | x::l -> f x@flat_map_f l
;;

let rec first_n =
 fun 0 -> K []
   | n -> function
          [] -> failwith "first_n" | x::l -> x::first_n (pred n) l
and last_n n l = iterate tl (list_length l-n) l ? failwith "last_n"
;;

let for_all p = for_all_p
 where rec for_all_p = function
     [] -> true | a::l -> p a && for_all_p l
;;

(* exists p [x1; ... ;xn] is false if p(xi) is false for every i.         *)
let exists p = exists_p
 where rec exists_p = function [] -> false | a::l -> p a || exists_p l
;;

let mem_list_list x = exists (mem x)
;;

let for_all2 rel = for_all2_rel
 where rec for_all2_rel =
  fun [] -> (function [] -> true | _ -> failwith "for_all2")
    | (x1::l1) -> function
           x2::l2 -> rel x1 x2 && for_all2_rel l1 l2
         | _ -> failwith "for_all2"
;;

let exists2 rel = exist2_rel
 where rec exist2_rel =
  fun [] -> (function [] -> false | _ -> failwith "exists2")
    | (x1::l1) -> function
           x2::l2 -> rel x1 x2 || exist2_rel l1 l2
         | _ -> failwith "exists2"
;;

(* exists_pair p [x1; ... ; xn] == true		     *)
let exists_pair p = exists_pair_p
 where rec exists_pair_p = function
     [] -> false | x::l -> exists (p x) l || exists_pair_p l
;;

(* for_all_pair p [x1; ... ; xn] == true      *)
let for_all_pair p = for_all_pair_p
 where rec for_all_pair_p = function
     [] -> true | x::l -> for_all (p x) l && for_all_pair_p l
;;

let filter_pos p = (share filter_aux
 where rec filter_aux = function
     [] -> raise Identity
   | x::l -> if p x then x::filter_aux l else share filter_aux l)

and filter_neg p = (share filter_aux
 where rec filter_aux = function
     [] -> raise Identity
   | x::l -> if p x then share filter_aux l else x::filter_aux l)

and filter_succeed p = (share filter_aux
 where rec filter_aux = function
     [] -> raise Identity
   | x::l -> p x;x::filter_aux l ? share filter_aux l)
;;

let do_list_replace f accu = do_list_f
 where rec do_list_f = function
     [] -> () | x::l -> accu := f x::!accu;do_list_f l
;;

let do_list_i_replace f accu = do_list_f
 where rec do_list_f i = function
     [] -> () | x::l -> accu := f i x::!accu;do_list_f (succ i) l
;;

let do_list_succeed_replace f accu = do_list_f
 where rec do_list_f = function
     [] -> () | x::l -> accu := f x::!accu;do_list_f l ? do_list_f l
;;

let add_set x s = if mem x s then s else x::s
;;

(* make_set [1;2;3;1;3;4;2;5] --> [1; 3; 4; 2; 5] *)
let make_set l = share make_aux l
 where rec make_aux = function
     [] -> raise Identity
   | x::l -> if mem x l then share make_aux l else x::make_aux l
;;

let intersect l1 l2 = filter_pos (C mem l2) l1
and subtract l1 l2 = filter_neg (C mem l2) l1
;;

let equal_set l1 l2 = subtract l1 l2 == [] && subtract l2 l1 == []
;;

(* Check if the elements of a list are all distinct *)
let rec distinct = function
    h::t -> not mem h t && distinct t | _ -> true
;;

let mem_assoc = exists o equal_fst
;;

let change l n f = change_f l n
 where rec change_f =
  fun [] -> failwith "change"
    | (h::t) n -> if n == 1 then f h::t else h::change_f t (pred n)
;;

let update l n x = change l n (K x)
;;

(* Initial segment of given length and remainder *)
let chop_list = (fun n l -> chop_aux n ([],l))
 where rec chop_aux =
  fun 0 (l1,l2) -> rev l1,l2
    | n -> function
           _,[] -> failwith "chop_list"
         | l1,h::t -> chop_aux (pred n) (h::l1,t)
;;

(* let last = hd o rev;;  *)
let last = function
    [] -> failwith "last"
  | prefix :: pair -> last_aux pair
      where rec last_aux = function
          x,[] -> x | _,prefix :: pair -> last_aux pair
;;

(* sep_last [x1;x2; ... ;xn] -> (xn,[x1;...;xn-1]) *)
let sep_last = function
    [] -> failwith "sep_last"
  | prefix :: pair -> sep_last_aux pair
      where rec sep_last_aux = function
          h,[] as pair -> pair
        | h,prefix :: pair -> let x,l = sep_last_aux pair in x,h::l
;;

(* add_last x [x1;x2; ... ;xn] -> [x1;x2; ... ;xn;x] *)
let add_last x l = l@[x]
;;

(* except_last = rev o tl o rev *)
let except_last = function
    [] -> failwith "except_last"
  | prefix :: pair -> except_last_aux pair
      where rec except_last_aux = function
          _,[] -> [] | x,prefix :: pair -> x::except_last_aux pair
;;

let rotate_left = function
    [] -> failwith "rotate_left" | a::l -> l@[a]
and rotate_right = function
    [] -> failwith "rotate_right" | l -> prefix :: (sep_last l)
;;

let select p = select_p
 where rec select_p = function
     [] -> failwith "select"
   | prefix :: (x,l as pair) ->
       if p x then pair else let u,ll = select_p l in u,x::ll
;;

(*sort (prefix <) [1; 9; 5; 2; 3; 4; 2; 1; 0] = [0; 1; 1; 2; 2; 3; 4; 5; 9] *)
let sort prefix > l =
 let rec merge = function
     [],l2 -> l2
   | l1,[] -> l1
   | (h1::t1 as l1),(h2::t2 as l2) ->
       if h1 > h2 then h1::merge (t1,l2) else h2::merge (l1,t2)
 and merge_sort_step = function
     [] -> []
   | [l] -> [l]
   | l1::l2::t -> merge (l1,l2)::merge_sort_step t
 and merge_sort_aux = function
     [] -> [] | [l] -> l | L -> merge_sort_aux (merge_sort_step L) in
  merge_sort_aux (map (fun x -> [x]) l)
;;

(* Lists of pairs and pairs of lists *)
let rec split = function
    (x1,x2)::l -> let l1,l2 = split l in x1::l1,x2::l2 | [] -> [],[]
;;

let rec combine = function
    h1::t1,h2::t2 -> (h1,h2)::combine (t1,t2)
  | [],[] -> []
  | _ -> failwith "combine"
;;

(* Applications of it_list, list_it and combine *)
let it_list2 f init list1 list2 =
 it_list f init (combine (list1,list2) ? failwith "it_list2")
;;

let list_it2 f list1 list2 =
 list_it f (combine (list1,list2) ? failwith "list_it2")
;;

(* Lists of consecutive integers *)
let interval n m = interval_n ([],m)
 where rec interval_n (l,m) =
  if n > m then l else interval_n (m::l,pred m)
;;

let range = interval 1
;;

(* Testing identity of values *)
let eq_fst x (t,_) = eq (t,x) and eq_snd x (_,t) = eq (t,x)
;;

let pair_assq x = find (fun (t,_) -> eq (t,x))
and pair_rev_assq x = find (fun (_,t) -> eq (t,x))
;;

let mem_assq = exists o eq_fst
;;

let assq x = snd o pair_assq x 
and rev_assq x = fst o pair_rev_assq x

and memq x = (memq_x
 where rec memq_x = function
     [] -> false | y::l -> eq (x,y) || memq_x l)
;;

let except_assq e = except_e
 where rec except_e = function
     [] -> [] | (x,_ as y)::l -> if x == e then l else y::except_e l
;;

let add_setq x s = if memq x s then s else x::s
;;

let make_setq l = share make_aux l
 where rec make_aux = function
     [] -> raise Identity
   | x::l -> if memq x l then share make_aux l else x::make_aux l
;;

let exceptq e = exceptq_e
 where rec exceptq_e = function
     [] -> [] | elem::l -> if e == elem then l else elem::exceptq_e l
;;

let intersectq l1 l2 = filter (C memq l2) l1
and subtractq l1 l2 = filter (neg (C memq l2)) l1
;;

(* unionq l1 l2 = subtractq l1 l2 @ l2  *)
let unionq l1 l2 = urec l1
 where rec urec = function
     [] -> l2 | a::l -> if memq a l2 then urec l else a::urec l
;;

let map_seg f v =
 let l = pred (seg_length v) in
 maprec 0
 where rec maprec n =
  f (seg_item (v,n))::(if n == l then [] else maprec (succ n))
;;

let map_seg_i f v =
 let l = pred (seg_length v) in
 maprec 0
 where rec maprec n =
  f n (seg_item (v,n))::(if n == l then [] else maprec (succ n))
;;

let map_vect_i f v = maprec 0
 where rec maprec n =
  if n >= vect_length v then [] else f n v.(n)::maprec (succ n)
;;

let list_of_vect = map_vect I
;;

let fold_vect f a1 v =
 let l = vect_length v in
 fold_f a1 0
 where rec fold_f a1 n =
  if n >= l then a1,[]
   else let a2,c2 = f a1 v.(n) in
        let a,cl = fold_f a2 (succ n) in a,c2::cl
;;

let it_vect f a v = it_vect_f a 0
 where rec it_vect_f a n =
  if n >= vect_length v then a else it_vect_f (f a v.(n)) (succ n)
;;

let vect_it f v a = vect_it_f 0
 where rec vect_it_f n =
  if n >= vect_length v then a else f v.(n) (vect_it_f (succ n))
;;

let is_null_queue = function qnil -> true | _ -> false
;;

let hd_queue = function
    qcons {Qhead=x; _} -> x | _ -> failwith "hd_queue"
;;

let tl_queue = function
    qcons {Qhead=x; Qtail=tl} -> tl | _ -> failwith "tl_queue"
;;

let clear_queue q = q.Qbody <- qnil;q.Qinsert <- qnil;()
;;

let do_queue f = do_rec
 where rec do_rec = function
     qnil -> ()
   | qcons ({Qhead=x; Qtail=_} as cell) -> f x;do_rec cell.Qtail
;;

let find_queue f = find_rec
 where rec find_rec = function
     qnil -> failwith "find"
   | qcons {Qhead=x; Qtail=tl} -> if f x then x else find_rec tl
;;

(* String operations *)
let ge_string (s1,s2) = le_string (s2,s1)
and lt_string (s1,s2) = not le_string (s2,s1)
and gt_string s_pair = not le_string s_pair
;;

(* String basic functions *)
let concat x y = x^y
;;

let ascii = implode_ascii o singleton
;;

let ascii_code s = nth_ascii (0,s)
;;

(* make a string of n characters which all have char as ASCII code *)
let make_string n char =
 if n < 0 then failwith "make_string" else raw_make_string n char
;;

let last_n_string n s =
 (if l < n then failwith "last_n_string" else sub_string s (l-n) n
 where l = length_string s)

and first_n_string n s =
 if length_string s < n then failwith "first_n_string"
  else sub_string s 0 n
;;

(* Tests the presence of a given character string *)
let present char str = scan_string str char 0 != -1
;;

(* To extract a string knowing its (positions) boundaries
  (chars of index from and to are included in the result). *)
let extract_string s From To = sub_string s From (succ (To-From))
;;

(* Substitutes all occurences (from pos n) of a character belonging to
   the string char by the string char' in the string s *)
let rec substitute_char char char' s = subst_rec
 where rec subst_rec n =
  (if p == -1 then extract_string s n (length_string s)
    else extract_string s n (pred p)^char'^subst_rec (succ p)
  where p = scan_string s char n)
;;

(* Substitutes all occurrences of the string old_str by the string
   new_str into the string s beginning from a given position *)
let rec substitute_string old_str new_str s = subst_rec
 where rec subst_rec n =
  (if p == -1 then extract_string s n (length_string s)
    else extract_string s n (pred p)^new_str^
         subst_rec (p+length_string old_str)
  where p = index_string s old_str n)
;;

(* Common words separators *)
let space_chars = " \f\n\r\t"
;;

(* To skip all chars belonging to string skip, at the beginning of string s *)
let skip_string skip s =
 if pos == -1 then "" else sub_string s pos (length_string s)
 where pos = span_string s skip 0
;;

(* To skip spaces and tabs *)
let skip_space = skip_string " \t"
;;

let skip_space_return = skip_string space_chars
;;

(* Extract the first word of string s (if word is " "*" ") *)
let first_word s =
 let s = skip_space_return s in
 if b != -1 then sub_string s 0 b else s
 where b = scan_string s space_chars 0
;;

(* Split a string in words (result in reverse order) *)
let rev_words sep s = words_aux (span_string s sep 0) []
 where rec words_aux pos l =
  (if pos < 0 then l
    else (if newpos == -1 then sub_string s pos (length_string s)::l
           else words_aux
                 (span_string s sep newpos) 
                 (sub_string s pos (newpos-pos)::l)
    where newpos = scan_string s sep pos))
;;

(* Split a string into words separated by string sep *)
let words2 sep = (fun s -> rev (revwords s))
 where revwords = rev_words sep
;;

(* If a word is slightly more general than " "*" " *)
let words = words2 space_chars
;;

(* break_string "_" "ab_cd__e_" = ["ab"; "cd"; ""; "e"; ""]  *)
let break_string sep string =
 fst (it_list scan ([],[]) (rev (sep::explode string)))
 where scan (strs,chars) char =
  if char = sep then implode chars::strs,[] else strs,char::chars
;;

(* Make a phrase from a list of strings and a separator *)
let make_phrase sep = make_phrase_sep
 where rec make_phrase_sep = function
     [] -> "" | [s] -> s | s::l -> s^sep^make_phrase_sep l
;;

(* chop_string 3 "CAML" --> "CAM","L" *)
let chop_string n =
 if n < 0 then failwith "chop_string"
  else fun s -> sub_string s 0 n,sub_string s n (length_string s)
;;

(* Miscellaneous operations *)
let string_of_bool = function true -> "true" | _ -> "false"
;;

let bool_of_string = function
    "true" -> true | "false" -> false | _ -> failwith "bool_of_string"
;;

let bool_of_obj = function
    obj_atom <:obj:Atom<()>> -> false | _ -> true
;;

(* The Objs *)
let cons_obj x y = obj_cons (x,y)
and is_obj_cons = function obj_cons c -> true | _ -> false
;;

let obj_nil = obj_atom <:obj:Atom<()>>
;;

let obj_left = function obj_cons (x,y) -> x | _ -> failwith "obj_left"
and obj_right = function
    obj_cons (x,y) -> y | _ -> failwith "obj_right"
;;

let string_of_obj = function
    obj_string s -> s | _ -> failwith "string_of_obj"
;;

let string_of_atom a = string_from_obj (obj_atom a)
;;

(* Warning: the functions
   add mult div sub add_float sub_float mult_float div_float succ_int pred_int
   Co pairing Y sigma pi change update
   are not used in the CAML system *)
