(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* caml_gram The grammar of CAML itself                                  *)
(*           Michel Mauny (translation from old Yacc interface)          *)
(*           Ascander Suarez                                             *)
(*           Pierre Weis                                                 *)

system module caml_gram ;;

#standard arith true;;

#fast arith true;;

#pragma let PARSE s =
              MLapply
               (MLvar "do_out_of_system",MLvar "parse_ol_grammar",[s]);;

let MLtypes_of_vars = map (fun s -> MLvartyp s);;

let eval_to_btagl e =
 match eval_prag_syntax e with
    (dynamic ([]:memory_tag list)) ->
      raise parse
       "Empty list of tags specified for an anonymous type at import"
  | (dynamic (btagl:memory_tag list)) -> btagl
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype
          (#<:Caml:Expr<#(MLconst (mlsystyp"memory_tag"))>>,[])]));;

let eval_macro_expr_ML e =
 match eval_prag_syntax e with
    (dynamic (prg:ML)) -> prg
  | d ->
      ill_typed_macro
       e d (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"ML"))>>,[]));;

let eval_macro_expr_MLdecl e =
 match eval_prag_syntax e with
    (dynamic (prg:MLdecl)) -> prg
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLdecl"))>>,[]));;

let eval_macro_expr_string_list e =
 match eval_prag_syntax e with
    (dynamic (l:string list)) -> l
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"string"))>>,[])]));;

let eval_macro_expr_bool test e_true e_false =
 match eval_prag_syntax test with
    (dynamic (true:bool)) -> e_true
  | (dynamic (false:bool)) -> e_false
  | d ->
      ill_typed_macro
       test d 
       (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"bool"))>>,[]));;

let eval_macro_expr_string e =
 match eval_prag_syntax e with
    (dynamic (s:string)) -> s
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"string"))>>,[]));;

let eval_macro_expr_MLtype e =
 match eval_prag_syntax e with
    (dynamic (mlty:MLtype)) -> mlty
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLtype"))>>,[]));;

let eval_macro_expr_MLpat_MLaction_list e =
 match eval_prag_syntax e with
    (dynamic (l:(MLpat * MLmatch_action) list)) -> l
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype
          (#<:Caml:Expr<#(MLconst (mlsystyp"*"))>>,
           [Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLpat"))>>,[]); 
            Gconsttype
            (#<:Caml:Expr<#(MLconst (mlsystyp"MLmatch_action"))>>,[])])]));;

let eval_macro_expr_MLconstruct_list e =
 match eval_prag_syntax e with
    (dynamic (l:MLconstruct list)) -> l
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype
          (#<:Caml:Expr<#(MLconst (mlsystyp"MLconstruct"))>>,[])]));;

let eval_macro_expr_MLlabel_list e =
 match eval_prag_syntax e with
    (dynamic (l:MLlabel list)) -> l
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLlabel"))>>,[])]));;

let eval_macro_expr_MLpat e =
 match eval_prag_syntax e with
    (dynamic (prg:MLpat)) -> prg
  | d ->
      ill_typed_macro
       e d (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLpat"))>>,[]));;

let eval_macro_expr_MLpat_list e =
 match eval_prag_syntax e with
    (dynamic (prg:MLpat list)) -> prg
  | d ->
      ill_typed_macro
       e d 
       (Gconsttype
        (#<:Caml:Expr<#(MLconst (mlsystyp"list"))>>,
         [Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"MLpat"))>>,[])]));;

grammar for values Caml = 
delimitor
  string is "\""
  comment is "%"
  ;
precedences
  right Literal "->";
  left Literal "or" Literal "||";
  left Literal "&" Literal "&&";
  right Literal "<-" Literal ":=";
  right Literal ",";
  left Literal "@" Literal "^";
  right Literal "::";
  left Literal "+" Literal "-";
  left Literal "*" Literal "/" INFIX;
  right Literal "**";
  precedence uminus;
  left Literal ".";
  nonassoc Literal "^}";
  nonassoc EOF;

rule entry Caml = 
    parse Caml_top t; Literal ";;" -> t
        
and Caml_top = 
    parse Decl td -> MLdecl td
        | Expr e -> ML e
        | Directive d -> MLdirective d
        | Macro_decl md -> MLpragma md
        
and entry Pragma = 
    parse Decl d; Literal ";;" -> Pragmadecl d
        | Expr e; Literal ";;" -> Pragmaexp e
        
and Directive = 
    parse Literal "directive"; Expr e -> Pragmaexp e
        
and Macro_decl = 
    parse Literal "mlet"; Val_binding vb -> Pragmadecl vb
        | Literal "mlet"; Literal "rec"; Val_binding vb
          -> Pragmadecl (MLrec vb)
        
and entry Expr0 = 
    parse Ce c -> MLconst c
        | MLIdent2 x -> MLvar x
        | Constructor c -> MLconstr c
        | Literal "it" -> MLit
        | Literal "any" -> MLany
        | Ol_program ol -> ol
        | MLescape e -> eval_macro_expr_ML e
        
and Exp1 = 
    parse Literal ("!" as bang); Exp1 e -> MLapply (MLvar bang,e,[])
        | Literal "dynamic"; Exp1 e -> MLdynamic e
        | Expr0 e -> e
        
and Expr1 = 
    parse Expr1 e; Literal "."; MLIdent id -> MLrecord_access (id,e)
        | Expr1 e; Literal "."; NUM n
          -> MLvect_access (e,MLconst (mlnum n))
        | Expr1 e1; Literal "."; Literal "("; Expr e2; Literal ")"
          -> MLvect_access (e1,e2)
        | Exp1 e -> e
        
and Expr13 = 
    parse Expr1 e1; Literal "."; MLIdent v; Literal "<-"; Fnexpr13 e2
          -> MLupdate (v,e1,e2)
        | Expr1 e1; Literal "."; NUM n; Literal "<-"; Fnexpr13 e2
          -> MLvect_assign (e1,MLconst (mlnum n),e2)
        | Expr1 e1; Literal "."; Literal "("; Expr e2; Literal ")";
          Literal "<-"; Fnexpr13 e3 -> MLvect_assign (e1,e2,e3)
        
and Ol_program = 
    parse Literal "<<";
          {do_out_of_system parse_ol_grammar !default_ol_grammar} e;
          Literal ">>" -> e
        | Literal "<:"; IDENT gname; Literal "<";
          {do_out_of_system parse_ol_grammar (gname,"")} e;
          Literal ">>" -> e
        | Literal "<:"; IDENT gname; Literal ":"; IDENT ext;
          Literal "<";
          {do_out_of_system parse_ol_grammar (gname,ext)} e;
          Literal ">>" -> e
        
and Expr2 = 
    parse Expr1 e; (+ (parse Expr1 e -> e
                           )) el -> MLapply (e,el)
        | Expr1 e -> e
        
and Expr8 = 
    parse Expr8 e; INFIX i; Expr8 e_prime
          -> MLapply (MLvar i,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("@" as a); Expr8 e_prime
          -> MLapply (MLvar a,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("^" as c); Expr8 e_prime
          -> MLapply (MLvar c,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("::" as dc); Expr8 e_prime
          -> MLapply (MLvar dc,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("+" as p); Expr8 e_prime
          -> MLapply (MLvar p,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("-" as m); Expr8 e_prime
          -> MLapply (MLvar m,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("*" as st); Expr8 e_prime
          -> MLapply (MLvar st,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("**" as st); Expr8 e_prime
          -> MLapply (MLvar st,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("/" as d); Expr8 e_prime
          -> MLapply (MLvar d,MLpair (e,e_prime),[])
        | Literal "-"; Expr8 e with precedence uminus -> mkuminus e
        | Expr2 e1; Literal "within"; Record_expr fl -> MLwithin (e1,fl)
        | Expr1 e1; Literal "."; Literal "view"; Literal "within";
          Record_expr fl -> MLwithin (MLrecord_access ("view",e1),fl)
        | Expr2 e -> e
        
and Expr9 = 
    parse Expr8 e; Literal ("=" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<" as lt); Expr8 e_prime
          -> MLapply (MLvar lt,MLpair (e,e_prime),[])
        | Expr8 e; Literal (">" as gt); Expr8 e_prime
          -> MLapply (MLvar gt,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<=" as le); Expr8 e_prime
          -> MLapply (MLvar le,MLpair (e,e_prime),[])
        | Expr8 e; Literal (">=" as ge); Expr8 e_prime
          -> MLapply (MLvar ge,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<>" as diff); Expr8 e_prime
          -> MLapply (MLvar diff,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("==" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("!=" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e -> e
        
and Expr10 = 
    parse Literal ("not" as n); Expr9 e -> MLapply (MLvar n,e,[])
        | Expr9 e -> e
        
and Expr12 = 
    parse Expr12 e; Literal "or"; Expr12 e_prime
          -> MLcond (e,MLconst (mlbool true),e_prime)
        | Expr12 e; Literal "&"; Expr12 e_prime
          -> MLcond (e,e_prime,MLconst (mlbool false))
        | Expr12 e; Literal "||"; Expr12 e_prime
          -> MLcond (e,MLconst (mlbool true),e_prime)
        | Expr12 e; Literal "&&"; Expr12 e_prime
          -> MLcond (e,e_prime,MLconst (mlbool false))
        | Expr10 e -> e
        
and Expr13 = 
    parse Expr12 e; Literal ","; Fnexpr13 e_prime -> MLpair (e,e_prime)
        | Expr12 e -> e
        
and Expr14 = 
    parse Expr13 e; Literal (":=" as ass); Fnexpr16 e_prime
          -> MLapply (MLvar ass,MLpair (e,e_prime),[])
        | Literal "at"; MLIdent id; Literal "<-"; Fnexpr16 e
          -> MLreplace (id,e)
        | Expr13 e -> e
        
and Expr15 = 
    parse Literal "raise"; Rs_expr e -> MLapply (MLvar "raise",e,[])
        | Expr14 e -> e
        
and Rs_expr = 
    parse Literal "("; Rs_expr e; Literal ")" -> e
        | Constructor_or_ident id; Fnexpr15 e -> MLapply (MLvar id,e,[])
        | Constructor_or_ident id -> MLvar id
        | MLescape e -> eval_macro_expr_ML e
        
and Expr0 = 
    parse Literal "continue"; IDENT i -> MLcontinue i
        | Literal "exit" -> MLexit
        | Literal "["; Exprs e; Literal "]" -> MLlist e
        | Literal "[|"; Exprs es; Literal "|]"
          -> MLvect_of_list (MLmutable true,MLlist es)
        | Literal "[|"; Literal "|]"
          -> MLvect_of_list (MLmutable true,MLvar "")
        | Literal "[<"; Exprs es; Literal ">]"
          -> MLvect_of_list (MLmutable false,MLlist es)
        | Literal "[<"; Literal ">]"
          -> MLvect_of_list (MLmutable false,MLvar "")
        
and Exprs = 
    parse Fnexpr16 e1; ( * (parse Literal ";"; Fnexpr16 e -> e
                                )) el
          -> (e1,el)
        
and If_expr16 = 
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true;
          Cond c -> MLcond (test,e_true,c)
        
and Cond = 
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true;
          Cond c -> MLcond (test,e_true,c)
        | Literal "else"; Fnexpr16 e -> e
        | -> MLconst mlnull
        
and Expr16 = 
    parse If_expr16 e -> e
        | Expr15 e -> e
        
and Seqexpr16 = 
    parse Seqexpr16 el; Literal ";"; Fnexpr16 e -> e::el
        | Fnexpr16 e -> [e]
        
and Expr17 = 
    parse Expr16 e; Literal ";"; Seqexpr16 es -> mkseq (e,es)
        | Expr16 e -> e
        
and Fnexpr = 
    parse Literal "fun"; Fun_Match m -> m
        | Literal "function"; Function_Match m -> m
        | Literal "when"; When_Match m -> m
        | Literal "match"; Expr e; Literal "with"; Function_Match m
          -> MLapply (m,e,[])
        | Literal "try"; Expr e; Literal "with"; Function_Match tm
          -> MLtry (e,tm)
        | Literal "vector"; Expr e_num; Literal "with";
          Function_Match m -> MLbuild_vect (MLmutable true,e_num,m)
        | Literal "segment"; Expr e_num; Literal "with";
          Function_Match m -> MLbuild_vect (MLmutable false,e_num,m)
        | Decl d; Decl_in_Expr e -> MLin (d,e)
        
and Decl_in_Expr = 
    parse Literal "in"; Expr e -> e
        | Decl d; Decl_in_Expr e -> MLin (d,e)
        
and Fnexpr13 = 
    parse Fnexpr e -> e
        | If_expr16 e -> e
        | Expr13 e -> e
        
and Fnexpr15 = 
    parse Fnexpr e -> e
        | Expr15 e -> e
        
and Fnexpr16 = 
    parse Fnexpr e -> e
        | Expr16 e -> e
        
and entry Expr_non_sequence = 
    parse Fnexpr16 e -> e
        
and entry Expr = 
    parse Literal "force"; Expr e -> MLforce e
        | Literal "protect"; Expr e -> MLprotect e
        | Expr17 e1; Literal "?"; Expr e2
          -> MLtry
             (e1,
              MLmatch
               (MLmatching
                (MLnolabel,[MLconpat ("failure",MLwildpat),MLaction e2])))
          
        | Literal "try"; Expr e1; Literal "handle"; Literal "with";
          Expr e2 -> MLtry (e1,e2)
        | Expr17 e; Literal "where"; Val_binding vb -> MLin (vb,e)
        | Expr17 e; Literal "where"; Literal "rec"; Val_binding vb
          -> MLin (MLrec vb,e)
        | Literal "vector"; Expr_of e_num_e_init
          -> MLinit_vect (MLmutable true,e_num_e_init)
        | Literal "vector"; Of_expr_list e_list
          -> MLvect_of_list (MLmutable true,e_list)
        | Literal "segment"; Expr_of e_num_e_init
          -> MLinit_vect (MLmutable false,e_num_e_init)
        | Literal "segment"; Of_expr_list e_list
          -> MLvect_of_list (MLmutable false,e_list)
        | Fnexpr e -> e
        | Expr17 e -> e
        
and Expr_of = 
    parse Expr e_num; Literal "of"; Expr2 e_init -> (e_num,e_init)
        
and Of_expr_list = 
    parse Literal "of"; Expr2 e_list -> e_list
        
and Expr0 = 
    parse Literal "("; Expr e; Literal ")" -> e
        | Literal "("; Literal ";"; Expr e; Literal ")" -> e
        | Literal "begin"; Expr e; Literal "end" -> e
        | Literal "("; Expr e; Type_constraint str; Literal ")"
          -> MLstraint (e,str)
        | Literal "while"; Expr e_test; Literal "do"; Expr e_loop_step;
          Literal "done" -> MLwhile (e_test,e_loop_step)
        | Literal "repeat"; Expr e_loop_step; Literal "until";
          Expr e_test; Literal "done"
          -> MLrepeat(e_test,e_loop_step)
        | Literal "loop"; Expr17 e_init; Literal "when"; Expr e_bound;
          Literal "step"; Expr e_loop; Literal "do"; Expr e_loop_step;
          Literal "done" -> MLloop (e_init,e_bound,e_loop,e_loop_step)
        | Literal "from"; Pat_is_expr p_e; Literal "to"; Expr e_bound;
          Literal "step"; Expr e_step; Literal "do"; Expr e_loop;
          Literal "done" -> MLfrom (p_e,e_bound,e_step,e_loop)
        | Literal "for"; Ident_is_expr p_e;
          (parse -> false
               | Literal "down" -> true
               ) down_flag;
          Literal "to"; Expr e_bound;
          (parse -> MLconst (mlnum #{1})
               | Literal "step"; Expr e_step -> e_step
               ) e_step;
          Literal "do"; Expr e_loop; Literal "done"
          -> MLfor (p_e,(down_flag,e_bound),e_step,e_loop)
        | Record_expr fl -> MLrecord fl
        
and Record_expr = 
    parse Literal "{"; Field_list fl; Literal "}" -> fl
        
and Field_list = 
    parse Field1 f1; ( * (parse Literal ";"; Field1 f -> f
                              )) fl
          -> (f1,fl)
        
and Field1 = 
    parse MLIdent id; Literal "="; Fnexpr16 e -> (id,e)
        | MLIdent id -> (id,MLvar id)
        
and Type_constraint = 
    parse Literal ":"; Type ty -> ty
        | Literal "#:"; Expr0 e -> eval_macro_expr_MLtype e
        
and entry Fun_Match = 
    parse Match m -> MLmatch (MLmatching (MLnolabel,m))
        
and entry Function_Match = 
    parse Function_Matching m -> MLmatch m
        
and entry Function_Matching = 
    parse Literal "continuing"; IDENT s; Umatch m
          -> MLmatching (MLlabelled s,m)
        | Umatch m -> MLmatching (MLnolabel,m)
        
and When_expr = 
    parse Expr12 e1 -> e1
        | Literal "_" -> MLconst (mlbool true)
        
and When_Match_case = 
    parse When_expr e1;
          (+ (parse Literal "&|"; When_expr e2; Literal "->"; Expr e3
                    -> (e2,e3)
                  )) el
          -> MLwhen_compound (e1,el)
        | When_expr e1; Literal "->"; Expr e2 -> MLwhen_simple (e1,e2)
        
and When_Match = 
    parse Bar_opt _; When_Match_case c;
          ( * (parse Literal "|"; When_Match_case c -> c
                   )) l
          -> MLwhen (c,l)
        
and entry Match = 
    parse Match1 ml -> rev ml
        
and Match1 = 
    parse Bpatat p; Match_rule mr -> [p,mr]
        | Match1 ml; Literal "|"; Bpatat p; Match_rule mr -> (p,mr)::ml
        | Match1 ml; Literal "#|"; Expr0 e
          -> rev_append (eval_macro_expr_MLpat_MLaction_list e) ml
        
and Match_rule = 
    parse Bpatat p; Match_rule mr
          -> MLaction (MLmatch (MLmatching (MLnolabel,[p,mr])))
        | Literal "->"; Expr e -> MLaction e
        
and entry Umatch_case = 
    parse Pat p; Literal "->"; Expr e -> (p,MLaction e)
        | Pat p; Literal "when"; Expr g; Literal "->"; Expr e
          -> (p,MLguard_action (g,e))
        
and entry Umatch = 
    parse Umatch1 uml -> rev uml
        
and Umatch1 = 
    parse Bar_opt _; Umatch_case umc -> [umc]
        | Umatch1 uml; Literal "|"; Umatch_case umc -> umc::uml
        | Umatch1 uml; Literal "#|"; Expr0 e
          -> rev_append (eval_macro_expr_MLpat_MLaction_list e) uml
        
and entry Decl = 
    parse Let _; Val_binding vb -> vb
        | Let _; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "type"; Type_binding tb -> MLtype tb
        | Literal "exception"; Exc_binding ebl -> MLexception ebl
        | Decl local_decl; Literal "in"; Decl decl
          -> MLlocal (local_decl,decl)
        | Literal "("; Decl d; Literal ")" -> d
        
and entry Val_binding = 
    parse Val_binding0 vb -> mkdecl vb
        | Val_binding vb1; Literal "and"; Val_binding0 vb2
          -> binarize (vb1,mkdecl vb2)
        | Val_binding vb1; Literal "#and"; Expr0 e
          -> binarize (vb1,eval_macro_expr_MLdecl e)
        
and Let = 
    parse Literal "let" -> ()
        | Literal "value" -> ()
        | Let _; Literal "and" -> ()
        
and Bar_opt = 
    parse -> ()
        | Literal "|" -> ()
        
and Pat_is_expr = 
    parse Bpat p; Literal "="; Expr e -> (p,e)
        
and Ident_is_expr = 
    parse IDENT p; Literal "="; Expr e -> (p,e)
        
and Is = 
    parse Literal "=" -> ()
        | Literal "be" -> ()
        
and Val_binding0 = 
    parse Bpat p; Is _; Expr e -> [p,e]
        | Bpatat p; Beurk b -> [p,b]
        | Bpatat p1; Inf i; Bpatat p2; Is _; Expr e
          -> [MLvarpat i,
              MLmatch
               (MLmatching (MLnolabel,[MLpairpat (p1,p2),MLaction e]))]
          
        | Val_binding0 vb; Literal "|"; Bpatat p; Beurk b -> (p,b)::vb
        
and Beurk = 
    parse Bpatat p; Beurk n
          -> MLmatch (MLmatching (MLnolabel,[p,MLaction n]))
        | Is _; Expr e -> e
        
and entry Overload_binding = 
    parse Overload_binding0 ov;
          ( * (parse Literal "and"; Overload_binding0 ov -> ov
                   )) ovl;
          Literal ";;" -> MLdecl (MLoverload (ov::ovl))
        
and Overload_binding0 = 
    parse MLIdent3 id; Literal "with"; MLIdent3_or_straint_list id_tc_l
          -> (id,id_tc_l)
        
and entry Forward_decl = 
    parse Straint_list strl; Literal ";;"
          -> MLdecl (MLforward (prefix :: strl))
        
and MLIdent3_straint = 
    parse MLIdent3 id; Type_constraint tc -> (id,tc)
        | Literal "("; MLIdent3 id; Type_constraint tc; Literal ")"
          -> (id,tc)
        
and entry Type_binding = 
    parse Type_binding_1 tb;
          ( * (parse Literal "and"; Type_binding_1 tb -> tb
                   )) tbl
          -> tb::tbl
        
and Type_binding_1 = 
    parse Type_name (id,vta); Literal "=="; Type ty
          -> MLabbrev_type (id,vta,ty)
        | Type_name (id,vta); Literal "="; Constructor_decl_list cl
          -> MLconcrete_type (id,vta,cl)
        | Type_name (id,vta); Literal "="; Literal "."; Literal ".";
          Literal "."; Constructor_decl_list cl
          -> MLextend_type (id,vta,true,cl)
        | Type_name (id,vta); Literal "="; Constructor_decl_list cl;
          Literal "."; Literal "."; Literal "."
          -> MLextend_type (id,vta,false,cl)
        | Type_name (id,vta); Literal "="; Labels l
          -> MLrecord_type (id,vta,l)
        | Type_name (id,vta); Literal "="; Constructor_decl_list cl;
          Literal "within"; Labels l -> MLview_type (id,vta,l,cl)
        | Type_name (id,vta) -> MLunknown_type (id,vta,all_the_tags)
        | Type_name (id,vta); Literal "with"; Literal "tags"; Expr0 e
          -> MLunknown_type (id,vta,eval_to_btagl e)
        
and Type_name = 
    parse Var_tyargs vta; MLIdent2 id -> (id,vta)
        | Var_ty vt1; Infixes i; Var_ty vt2 -> (i,[vt1; vt2])
        
and Labels = 
    parse Literal "{"; Labs l; Literal "}" -> l
        
and Constr_decl_list = 
    parse ( * (parse Literal "|"; Constructor_decl c -> c
                   )) cl -> cl
        | Constr_decl_list cl; Literal "#|"; Expr0 e
          -> rev_append (eval_macro_expr_MLconstruct_list e) cl
        
and entry Constructor_decl_list = 
    parse Bar_opt _; Constructor_decl c; Constr_decl_list cl -> c::cl
        | Bar_opt _; Constructor_decl c; Constr_decl_list cl;
          Literal "|" -> c::cl
        
and entry Constructor_decl = 
    parse Constructor_or_ident id; Literal "of"; Type ty
          -> MLconstruct (id,ty)
        | Constructor_or_ident id -> MLconstruct0 id
        | Mutable _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Lazy _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | Parallel _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_plabel_qualificator,ty)
        
and Var_tyargs = 
    parse -> []
        | Var_ty v -> [v]
        | Literal "("; Var_tyl vtl; Var_ty v; Literal ")"
          -> rev (v::vtl)
        
and Var_tyl = 
    parse -> []
        | Var_tyl vtl; Var_ty v; Literal "," -> v::vtl
        
and Lazy = 
    parse Literal "lazy" -> ()
        | Literal "*" -> ()
        
and Parallel = 
    parse Literal "parallel" -> ()
        | Literal "&" -> ()
        
and Mutable = 
    parse Literal "mutable" -> ()
        | Literal "!" -> ()
        
and Labs = 
    parse Label_decl_list l
          -> (match rev l with
                 prefix :: labs -> labs | _ -> system_error "No labels")
          
        
and entry Label_decl_list = 
    parse Label_decl_list ll; Literal ";"; Label_decl l -> l::ll
        | Label_decl l -> [l]
        | Label_decl_list ll; Literal "#;"; Expr0 e
          -> rev_append (eval_macro_expr_MLlabel_list e) ll
        
and entry Label_decl = 
    parse MLIdent id; Literal ":"; Type ty -> MLlabel (id,ty)
        | Mutable _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Lazy _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_llabel_qualificator,ty)
        | Parallel _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_plabel_qualificator,ty)
        
and entry Exc_binding = 
    parse Constructor_decl cd;
          ( * (parse Literal "and"; Constructor_decl cd -> cd
                   )) cdl
          -> cd::cdl
        
and Pat1 = 
    parse Constructor_or_ident id; Bpatat p -> MLconpat (id,p)
        | Literal "dynamic"; Bpatat p -> MLdynpat p
        | Bpatat p -> p
        
and Pat4 = 
    parse Pat4 p1; Literal ","; Pat4 p2 -> MLpairpat (p1,p2)
        | Pat4 p1; INFIX i; Pat4 p2 -> MLconpat (i,MLpairpat (p1,p2))
        | Pat4 p1; Literal ("::" as c); Pat4 p2
          -> MLconpat (c,MLpairpat (p1,p2))
        | Pat1 p -> p
        
and Pat5 = 
    parse Or_pat orp -> MLorpat orp
        | Pat4 p -> p
        
and Or_pat = 
    parse Pat4 p1; (+ (parse Literal "|"; Pat4 p -> p
                           )) ops
          -> (p1,prefix :: ops)
        | Pat4 p1; Literal "#|"; MLescape e
          -> (p1,eval_macro_expr_MLpat_list e)
        
and entry Pat = 
    parse Pat5 p; Literal "as"; Bpat1 as_pat -> MLsynpat (p,as_pat)
        | Pat5 p; Literal "within"; Record_pat ps -> MLwithinpat (p,ps)
        | Pat5 p -> p
        
and entry Bpat1 = 
    parse Constante c -> MLconstpat c
        | Literal "_" -> MLwildpat
        | Literal "*" -> MLlazywildpat
        | Constructor s -> MLcon0pat s
        | MLIdent2 id -> MLvarpat id
        | Literal "strict"; MLIdent2 id -> MLstrictpat (MLvarpat id)
        | MLescape e -> eval_macro_expr_MLpat e
        | Literal "["; Pats ps; Literal "]" -> ps
        | Record_pat ps -> MLrecordpat ps
        | Literal "("; Pat p; Literal ")" -> p
        | Literal "("; Pat p; Type_constraint str; Literal ")"
          -> MLstraintpat (p,str)
        | Ol_program ol_exp -> expr_to_pat ol_exp
        
and Record_pat = 
    parse Literal "{"; Lab_pats ps; Literal "}" -> ps
        
and Bpatat = 
    parse Bpat1 p; Literal "at"; MLIdent id -> MLoccpat (p,id)
        | Bpat1 p -> p
        
and entry Bpat = 
    parse Bpatat p1; Literal ","; Bpat p2 -> MLpairpat (p1,p2)
        | Bpatat p -> p
        
and Pats = 
    parse Pat p -> MLconpat ("::",MLpairpat (p,MLvarpat ""))
        | Pat p; Literal ";"; Pats pl
          -> MLconpat ("::",MLpairpat (p,pl))
        
and Lab_pat = 
    parse MLIdent id; Literal "="; Pat p -> MLlabelpat (id,p)
        | MLIdent id -> MLlabelpat (id,MLvarpat id)
        | Literal "_" -> MLlabelwildpat
        
and Lab_pats = 
    parse Lab_pat lp; ( * (parse Literal ";"; Lab_pat lp -> lp
                               )) lpl
          -> (lp,lpl)
        
and Ce = 
    parse NUM n -> mlnum n
        | INT i -> mlint i
        | FLOAT f -> mlfloat f
        | RATIO f -> mlratio f
        | BIGINT f -> mlbig_int f
        | CHAR c -> mlchar c
        | STRING s -> mlstring s
        | BOOL b -> mlbool b
        | Literal "("; Literal ")" -> mlnull
        | Literal "{"; Literal "}" -> mlnull
        
and Constante = 
    parse Literal "-"; NUM n with precedence uminus
          -> mlnum (minus_num n)
        | Literal "-"; INT i with precedence uminus
          -> mlint (minus_int i)
        | Literal "-"; FLOAT f with precedence uminus
          -> mlfloat (minus_float f)
        | Literal "-"; RATIO f with precedence uminus
          -> mlratio (minus_ratio f)
        | Literal "-"; BIGINT f with precedence uminus
          -> mlbig_int (minus_big_int f)
        | Ce c -> c
        
and Type1 = 
    parse Var_ty vty -> MLvartyp vty
        | MLIdent2 const -> MLconsttyp (const,[])
        | Literal "("; Type ty; Literal ")" -> ty
        | Type1 tyarg; MLIdent2 tyco -> MLconsttyp (tyco,[tyarg])
        | Literal "("; Typel args; Literal ")"; MLIdent2 ty
          -> MLconsttyp (ty,args)
        
and Typel = 
    parse Type ty; (+ (parse Literal ","; Type t -> t
                           )) tyl
          -> ty::prefix :: tyl
        
and Type2 = 
    parse Type1 ty1; Type_infixes tyi; Type2 ty2
          -> MLconsttyp (tyi,[ty1; ty2])
        | Type1 ty -> ty
        
and entry Type = 
    parse Type tysrc; Literal ("->" as arrow); Type tygl
          -> MLconsttyp (arrow,[tysrc; tygl])
        | Type2 ty1; Literal ("*" as b_and); Type ty2
          -> MLconsttyp (b_and,[ty1; ty2])
        | Type2 ty -> ty
        
and Var_ty = 
    parse Literal "'"; MLIdent var -> var
        
and MLIdent0 = 
    parse IDENT var -> var
        | Literal "["; Literal "]" -> ""
        
and MLIdent = 
    parse MLIdent0 var -> var
        | MLInfix i -> i
        
and Prefix_Ident = 
    parse Literal "prefix"; MLInfix i -> i
        
and MLIdent2 = 
    parse MLIdent0 var -> var
        | Prefix_Ident var -> var
        
and Constructor = 
    parse Literal "'"; IDENT id -> "'"^id
        | Literal "prefix"; CInfixes id -> id
        
and Constructor_or_ident = 
    parse Constructor c -> c
        | MLIdent2 id -> id
        
and Inf = 
    parse INFIX i -> i
        | Literal ("+" as p) -> p
        | Literal ("**" as p) -> p
        | Literal ("/" as d) -> d
        | Literal ("<=" as l) -> l
        | Literal (">=" as g) -> g
        | Literal ("<>" as d) -> d
        | Literal ("<" as l) -> l
        | Literal (">" as g) -> g
        | Literal ("::" as c) -> c
        | Literal ("@" as a) -> a
        | Literal ("&" as m) -> m
        | Literal ("or" as d) -> d
        | Literal ("&&" as m) -> m
        | Literal ("||" as d) -> d
        | Literal ("^" as c) -> c
        | Literal ("!=" as a) -> a
        | Literal (":=" as a) -> a
        
and Type_infixes = 
    parse Inf i -> i
        | Literal ("-" as m) -> m
        
and Infixes = 
    parse Type_infixes i -> i
        | Literal ("*" as a) -> a
        | Literal ("==" as a) -> a
        | Literal ("=" as e) -> e
        
and CInfixes = 
    parse Literal "'"; Infixes i -> "'"^i
        
and Prefixes = 
    parse Literal ("not" as n) -> n
        | Literal ("!" as b) -> b
        
and MLInfix = 
    parse Infixes i -> i
        | Prefixes p -> p
        
and MLIdent3_or_straint_list = 
    parse MLIdent3_or_straint id_tc;
          ( * (parse Literal ","; MLIdent3_or_straint id_tc -> id_tc
                   )) id_tc_l
          -> id_tc::id_tc_l
        
and MLIdent3 = 
    parse IDENT var -> var
        | Prefix_Ident var -> var
        | MLescape e -> eval_macro_expr_string e
        
and MLIdent3_or_straint = 
    parse MLIdent3 id -> MLvar id
        | MLIdent3_straint (id,tc) -> MLstraint (MLvar id,tc)
        
and entry Export_list = 
    parse Export1 exp;
          ( * (parse Literal ";"; Export1 exp -> exp
                   )) expl
          -> exp::expl
        
and Export1 = 
    parse Literal "value"; MLIdentl idl
          -> MLvalue_spec (uncons (map_type_var idl))
        | Literal "type"; MLIdentl idl
          -> MLtype_spec (uncons (map_unknown_type idl))
        | Literal "abstype"; MLIdentl idl
          -> MLtype_spec (uncons (map_abstract_type idl))
        | Literal "exception"; MLIdentl idl
          -> MLexception_spec (uncons (map_unknown_constructor idl))
        
and entry Import_list = 
    parse Import2 imp -> (imp,[])
        | Import2 imp; Literal "from"; File_list fl -> (imp,fl)
        
and File_list = 
    parse Expr0 name;
          ( * (parse Literal ","; Expr0 n -> eval_macro_expr_string n
                   )) nl
          -> eval_macro_expr_string name::nl
        
and Import2 = 
    parse -> []
        | Import1 imp;
          ( * (parse Literal ";"; Import1 imp -> imp
                   )) impl
          -> imp::impl
        
and Import1 = 
    parse Literal "value"; Straint_list strl -> MLvalue_spec strl
        | Literal "type"; Type_binding tyl -> MLtype_spec (uncons tyl)
        | Literal "exception"; Exc_binding eb
          -> MLexception_spec (uncons eb)
        
and MLIdentl = 
    parse MLIdent3 id;
          ( * (parse Literal "and"; MLIdent3 id -> id
                   )) idl
          -> id::idl
        
and entry Straint_list = 
    parse MLIdent3_straint str1;
          ( * (parse Literal "and"; MLIdent3_straint str -> str
                   )) strl
          -> (str1,strl)
        
and MLescape = 
    parse Literal "#"; Expr0 e -> e
        
;;

let coerce_to_MLsyntax f arg =
 match sys_eval_syntax (f arg) with
    (dynamic (s:MLsyntax)) -> s | _ -> system_error "Ill built syntax"

and coerce_to_ML f arg =
 match sys_eval_syntax (f arg) with
    (dynamic (s:ML)) -> s | _ -> system_error "Ill built syntax"

and coerce_to_MLpat f arg =
 match sys_eval_syntax (f arg) with
    (dynamic (s:MLpat)) -> s | _ -> system_error "Ill built syntax"

and coerce_to_MLtype f arg =
 match sys_eval_syntax (f arg) with
    (dynamic (s:MLtype)) -> s | _ -> system_error "Ill built syntax"

and coerce_to_MLdecl f arg =
 match sys_eval_syntax (f arg) with
    (dynamic (s:MLdecl)) -> s | _ -> system_error "Ill built syntax";;

let parse_caml_expr = coerce_to_ML (Caml "Expr").Parse_raw

and parse_caml_expr0 = coerce_to_ML (Caml "Expr0").Parse_raw

and parse_caml_expr_non_sequence =
 coerce_to_ML (Caml "Expr_non_sequence").Parse_raw

and parse_caml_pat = coerce_to_MLpat (Caml "Pat").Parse_raw

and parse_caml_let_pat = coerce_to_MLpat (Caml "Bpat").Parse_raw

and parse_caml_decl = coerce_to_MLdecl (Caml "Decl").Parse_raw

and parse_caml_val_binding =
 coerce_to_MLdecl (Caml "Val_binding").Parse_raw

and parse_caml_pat0 = coerce_to_MLpat (Caml "Bpat1").Parse_raw

and parse_caml_typ = coerce_to_MLtype (Caml "Type").Parse_raw

and parse_caml = coerce_to_MLsyntax (Caml "Caml").Parse_raw

and parse_caml_pragma = (Caml "Pragma").Parse_raw

and parse_caml_strl = (Caml "Straint_list").Parse_raw

and parse_caml_import_list = (Caml "Import_list").Parse_raw

and parse_caml_export_list = (Caml "Export_list").Parse_raw

and parse_forward_decl =
 coerce_to_MLsyntax (Caml "Forward_decl").Parse_raw

and parse_overload_decl =
 coerce_to_MLsyntax (Caml "Overload_binding").Parse_raw;;

let eval_lex_macro () =
 lex_reread
  (let e = parse_caml_expr0 () in
    match eval_prag_syntax e with
       (dynamic (s:string)) -> s
     | d ->
         ill_typed_macro
          e d 
          (Gconsttype (#<:Caml:Expr<#(MLconst (mlsystyp"string"))>>,[])));;

let parse_caml_straint_list () =
 match sys_eval_syntax (parse_caml_strl ()) with
    (dynamic (l:(string * MLtype) * (string * MLtype) list)) -> l
  | _ -> system_error "parse_caml_straint_list";;

();;

end module with
 value parse_caml_expr
 and parse_caml_expr0
 and parse_caml_expr_non_sequence
 and parse_caml_pat
 and parse_caml_pat0
 and parse_caml_let_pat
 and parse_caml_decl
 and parse_caml_val_binding
 and parse_caml_typ
 and parse_caml
 and parse_caml_pragma
 and parse_caml_straint_list
 and parse_caml_import_list
 and parse_caml_export_list
 and parse_forward_decl
 and parse_overload_decl
 and eval_lex_macro
 and Caml;;
