(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* caml_gram The grammar of CAML itself                                  *)
(*           Michel Mauny (translation from old Yacc interface)          *)
(*           Ascander Suarez                                             *)
(*           Pierre Weis                                                 *)

system module caml_gram ;;

#standard arith true;;

#fast arith true;;

let MLpair_to_pair = function
    MLconst (mlstring s1),MLconst (mlstring s2) -> s1,s2
  | _ -> raise parse "wrong call to an object grammar";;

let MLstring_to_string = function
    MLconst (mlstring s) -> s
  | _ -> raise parse "wrong call to an object grammar";;

#pragma let PARSE s =
         match s with
                  MLpair (s1,MLconst (mlstring "")) ->
                    MLapply
                    (MLvar "ML_to_MML",
                     MLapply
                     (MLvar "do_out_of_system",MLvar "parse_ol_grammar",
                      [MLpair
                       (MLapply (MLvar "MLstring_to_string",s1,[]),
                        MLconst (mlstring ""))]),
                     [])
                | MLpair _ ->
                    MLapply
                    (MLvar "ML_to_MML",
                     MLapply
                     (MLvar "do_out_of_system",MLvar "parse_ol_grammar",
                      [MLapply (MLvar "MLpair_to_pair",s,[])]),
                     [])
                | _ ->
                    MLapply
                    (MLvar "ML_to_MML",
                     MLapply
                     (MLvar "do_out_of_system",MLvar "parse_ol_grammar",
                      [s]),
                     [])
;;

let MLtypes_of_vars = map (fun s -> MLvartyp s);;

let MLpair_to_syntax = function
    MLpair (MLconst (mlstring s1),MLconst (mlstring s2)) -> s1,s2
  | _ -> system_error "wrong \"Syntax\" lexeme";;

let ML_to_MML (expr:ML) = MLquote (dynamic expr);;

let MML_to_MLpat = function
    MLquote (dynamic (expr:ML)) -> MLquote (dynamic (expr_to_pat expr))
  | _ -> system_error "MML_to_MLpat";;

let mk_type_binding ((x,y),z) = x,y,z;;

grammar for programs CAML = 
delimitor
  string is "\""
  comment is "%"
  ;
precedences
  right Literal "->";
  left Literal "or" Literal "||";
  left Literal "&" Literal "&&";
  right Literal "<-" Literal ":=";
  right Literal ",";
  left Literal "@" Literal "^";
  right Literal "::";
  left Literal "+" Literal "-";
  left Literal "*" Literal "/" INFIX;
  right "**";
  precedence uminus;
  left Literal ".";
  nonassoc Literal "^}";
  nonassoc EOF;

rule entry Caml = 
    parse Caml_top t; Literal ";;" -> t
        
and Caml_top = 
    parse Decl td -> MLdecl td
        | Expr e -> ML e
        
and entry MLnum = 
    parse NUM n -> MLconst (mlnum n)
        | MLescape e -> MLconst (mlnum e)
        
and entry MLstring = 
    parse STRING s -> MLconst (mlstring s)
        | MLescape e -> MLconst (mlstring e)
        
and entry MLbool = 
    parse BOOL b -> MLconst (mlbool b)
        | MLescape e -> MLconst (mlbool e)
        
and entry MLint = 
    parse INT i -> MLconst (mlint i)
        | MLescape e -> MLconst (mlint e)
        
and entry MLfloat = 
    parse FLOAT f -> MLconst (mlfloat f)
        | MLescape e -> MLconst (mlfloat e)
        
and entry MLratio = 
    parse RATIO c -> MLconst (mlratio c)
        | MLescape e -> MLconst (mlratio e)
        
and entry MLbig_int = 
    parse BIGINT c -> MLconst (mlbig_int c)
        | MLescape e -> MLconst (mlbig_int e)
        
and entry MLchar = 
    parse CHAR c -> MLconst (mlchar c)
        | MLescape e -> MLconst (mlchar e)
        
and entry MLvar = 
    parse MLIdent2 v -> MLvar v
        | MLescape e -> MLvar e
        
and entry MLvarpat = 
    parse MLIdent2 v -> MLvarpat v
        | MLescape e -> MLvarpat e
        
and entry Expr0 = 
    parse Ce c -> MLconst c
        | MLIdent2 x -> MLvar x
        | Constructor c -> MLconstr c
        | Literal "it" -> MLit
        | Literal "any" -> MLany
        | Ol_program ol -> ol
        | MLescape e -> e
        
and Exp1 = 
    parse Literal ("!" as bang); Exp1 e -> MLapply (MLvar bang,e,[])
        | Literal "dynamic"; Exp1 e -> MLdynamic e
        | Expr0 e -> e
        
and Expr1 = 
    parse Expr1 e; Literal "."; MLIdent id -> MLrecord_access (id,e)
        | Expr1 e; Literal "."; NUM n
          -> MLvect_access (e,MLconst (mlnum n))
        | Expr1 e1; Literal "."; Literal "("; Expr e2; Literal ")"
          -> MLvect_access (e1,e2)
        | Exp1 e -> e
        
and Expr13 = 
    parse Expr1 e1; Literal "."; MLIdent v; Literal "<-"; Fnexpr13 e2
          -> MLupdate (v,e1,e2)
        | Expr1 e1; Literal "."; NUM n; Literal "<-"; Fnexpr13 e2
          -> MLvect_assign (e1,MLconst (mlnum n),e2)
        | Expr1 e1; Literal "."; Literal "("; Expr e2; Literal ")";
          Literal "<-"; Fnexpr13 e3 -> MLvect_assign (e1,e2,e3)
        
and Ol_program = 
    parse Literal "<<";
          {ML_to_MML
            (do_out_of_system parse_ol_grammar !default_ol_grammar)} e;
          Literal ">>" -> e
        | Literal "<:"; IDENT gname; Literal "<";
          {ML_to_MML
            (do_out_of_system
              parse_ol_grammar (MLstring_to_string gname,""))} e;
          Literal ">>" -> e
        | Literal "<:"; IDENT gname; Literal ":"; IDENT ext;
          Literal "<";
          {ML_to_MML
            (do_out_of_system
              parse_ol_grammar (MLpair_to_pair (gname,ext)))} e;
          Literal ">>" -> e
        
and Expr2 = 
    parse Expr1 e; (+ (parse Expr1 e -> e
                           )) el -> MLapply (e,el)
        | Expr1 e -> e
        
and Expr8 = 
    parse Expr8 e; INFIX i; Expr8 e_prime
          -> MLapply (MLvar i,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("@" as a); Expr8 e_prime
          -> MLapply (MLvar a,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("^" as c); Expr8 e_prime
          -> MLapply (MLvar c,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("::" as dc); Expr8 e_prime
          -> MLapply (MLvar dc,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("+" as p); Expr8 e_prime
          -> MLapply (MLvar p,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("-" as m); Expr8 e_prime
          -> MLapply (MLvar m,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("*" as st); Expr8 e_prime
          -> MLapply (MLvar st,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("**" as st); Expr8 e_prime
          -> MLapply (MLvar st,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("/" as d); Expr8 e_prime
          -> MLapply (MLvar d,MLpair (e,e_prime),[])
        | Literal "-"; Expr8 e with precedence uminus
          -> MLapply (MLvar minus_name,e,[])
        | Expr2 e1; Literal "within"; Record_expr fl -> MLwithin (e1,fl)
        | Expr1 e1; Literal "."; Literal "view"; Literal "within";
          Record_expr fl -> MLwithin (MLrecord_access ("view",e1),fl)
        | Expr2 e -> e
        
and Expr9 = 
    parse Expr8 e; Literal ("=" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<" as lt); Expr8 e_prime
          -> MLapply (MLvar lt,MLpair (e,e_prime),[])
        | Expr8 e; Literal (">" as gt); Expr8 e_prime
          -> MLapply (MLvar gt,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<=" as le); Expr8 e_prime
          -> MLapply (MLvar le,MLpair (e,e_prime),[])
        | Expr8 e; Literal (">=" as ge); Expr8 e_prime
          -> MLapply (MLvar ge,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("<>" as diff); Expr8 e_prime
          -> MLapply (MLvar diff,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("==" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e; Literal ("!=" as eq); Expr8 e_prime
          -> MLapply (MLvar eq,MLpair (e,e_prime),[])
        | Expr8 e -> e
        
and Expr10 = 
    parse Literal ("not" as n); Expr9 e -> MLapply (MLvar n,e,[])
        | Expr9 e -> e
        
and Expr12 = 
    parse Expr12 e; Literal "or"; Expr12 e_prime
          -> MLcond (e,MLconst (mlbool true),e_prime)
        | Expr12 e; Literal "&"; Expr12 e_prime
          -> MLcond (e,e_prime,MLconst (mlbool false))
        | Expr12 e; Literal "||"; Expr12 e_prime
          -> MLcond (e,MLconst (mlbool true),e_prime)
        | Expr12 e; Literal "&&"; Expr12 e_prime
          -> MLcond (e,e_prime,MLconst (mlbool false))
        | Expr10 e -> e
        
and Expr13 = 
    parse Expr12 e; Literal ","; Fnexpr13 e_prime -> MLpair (e,e_prime)
        | Expr12 e -> e
        
and Expr14 = 
    parse Expr13 e; Literal (":=" as ass); Fnexpr16 e_prime
          -> MLapply (MLvar ass,MLpair (e,e_prime),[])
        | Literal "at"; MLIdent id; Literal "<-"; Fnexpr16 e
          -> MLreplace (id,e)
        | Expr13 e -> e
        
and Expr15 = 
    parse Literal "raise"; Rs_expr e -> MLapply (MLvar "raise",e,[])
        | Expr14 e -> e
        
and Rs_expr = 
    parse Literal "("; Rs_expr e; Literal ")" -> e
        | Constructor_or_ident id; Fnexpr15 e -> MLapply (MLvar id,e,[])
        | Constructor_or_ident id -> MLvar id
        | MLescape e -> e
        
and Expr0 = 
    parse Literal "continue"; IDENT i -> MLcontinue i
        | Literal "exit" -> MLexit
        | Literal "["; Exprs e; Literal "]" -> MLlist e
        | Literal "[|"; Exprs es; Literal "|]"
          -> MLvect_of_list (MLmutable true,MLlist es)
        | Literal "[|"; Literal "|]"
          -> MLvect_of_list (MLmutable true,MLvar "")
        | Literal "[<"; Exprs es; Literal ">]"
          -> MLvect_of_list (MLmutable false,MLlist es)
        | Literal "[<"; Literal ">]"
          -> MLvect_of_list (MLmutable false,MLvar "")
        
and Exprs = 
    parse Fnexpr16 e1; ( * (parse Literal ";"; Fnexpr16 e -> e
                                )) el
          -> (e1,el)
        
and If_expr16 = 
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true;
          Cond c -> MLcond (test,e_true,c)
        
and Cond = 
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true;
          Cond c -> MLcond (test,e_true,c)
        | Literal "else"; Fnexpr16 e -> e
        | -> MLconst mlnull
        
and Expr16 = 
    parse If_expr16 e -> e
        | Expr15 e -> e
        
and Seqexpr16 = 
    parse Seqexpr16 el; Literal ";"; Fnexpr16 e -> e::el
        | Fnexpr16 e -> [e]
        
and Expr17 = 
    parse Expr16 e; Literal ";"; Seqexpr16 es -> MLseq (e::rev es)
        | Expr16 e -> e
        
and Fnexpr = 
    parse Literal "fun"; Fun_Match m -> m
        | Literal "function"; Function_Match m -> m
        | Literal "when"; When_Match m -> m
        | Literal "match"; Expr e; Literal "with"; Function_Match m
          -> MLapply (m,e,[])
        | Literal "try"; Expr e; Literal "with"; Function_Match tm
          -> MLtry (e,tm)
        | Literal "vector"; Expr e_num; Literal "with";
          Function_Match m -> MLbuild_vect (MLmutable true,e_num,m)
        | Literal "segment"; Expr e_num; Literal "with";
          Function_Match m -> MLbuild_vect (MLmutable false,e_num,m)
        | Decl d; Decl_in_Expr e -> MLin (d,e)
        
and Decl_in_Expr = 
    parse Literal "in"; Expr e -> e
        | Decl d; Decl_in_Expr e -> MLin (d,e)
        
and Fnexpr13 = 
    parse Fnexpr e -> e
        | If_expr16 e -> e
        | Expr13 e -> e
        
and Fnexpr15 = 
    parse Fnexpr e -> e
        | Expr15 e -> e
        
and Fnexpr16 = 
    parse Fnexpr e -> e
        | Expr16 e -> e
        
and entry Expr_non_sequence = 
    parse Fnexpr16 e -> e
        
and entry Expr = 
    parse Literal "force"; Expr e -> MLforce e
        | Literal "protect"; Expr e -> MLprotect e
        | Expr17 e1; Literal "?"; Expr e2
          -> MLtry
             (e1,
              MLmatch
               (MLmatching
                (MLnolabel,[MLconpat ("failure",MLwildpat),MLaction e2])))
          
        | Literal "try"; Expr e1; Literal "handle"; Literal "with";
          Expr e2 -> MLtry (e1,e2)
        | Expr17 e; Literal "where"; Val_binding vb -> MLin (vb,e)
        | Expr17 e; Literal "where"; Literal "rec"; Val_binding vb
          -> MLin (MLrec vb,e)
        | Literal "vector"; Expr_of e_num_e_init
          -> MLinit_vect (MLmutable true,e_num_e_init)
        | Literal "vector"; Of_expr_list e_list
          -> MLvect_of_list (MLmutable true,e_list)
        | Literal "segment"; Expr_of e_num_e_init
          -> MLinit_vect (MLmutable false,e_num_e_init)
        | Literal "segment"; Of_expr_list e_list
          -> MLvect_of_list (MLmutable false,e_list)
        | Fnexpr e -> e
        | Expr17 e -> e
        
and Expr_of = 
    parse Expr e_num; Literal "of"; Expr2 e_init -> (e_num,e_init)
        
and Of_expr_list = 
    parse Literal "of"; Expr2 e_list -> e_list
        
and Expr0 = 
    parse Literal "("; Expr e; Literal ")" -> e
        | Literal "("; Literal ";"; Expr e; Literal ")" -> e
        | Literal "begin"; Expr e; Literal "end" -> e
        | Literal "("; Expr e; Type_constraint str; Literal ")"
          -> MLstraint (e,str)
        | Literal "while"; Expr e_test; Literal "do"; Expr e_loop_step;
          Literal "done" -> MLwhile (e_test,e_loop_step)
        | Literal "repeat"; Expr e_loop_step; Literal "until";
          Expr e_test; Literal "done"
          -> MLrepeat(e_test,e_loop_step)
        | Literal "loop"; Expr17 e_init; Literal "when"; Expr e_bound;
          Literal "step"; Expr e_loop; Literal "do"; Expr e_loop_step;
          Literal "done" -> MLloop (e_init,e_bound,e_loop,e_loop_step)
        | Literal "from"; Pat_is_expr p_e; Literal "to"; Expr e_bound;
          Literal "step"; Expr e_step; Literal "do"; Expr e_loop;
          Literal "done" -> MLfrom (p_e,e_bound,e_step,e_loop)
        | Literal "for"; Ident_is_expr p_e;
          (parse -> false
               | Literal "down" -> true
               ) down_flag;
          Literal "to"; Expr e_bound;
          (parse -> MLconst (mlnum #{1})
               | Literal "step"; Expr e_step -> e_step
               ) e_step;
          Literal "do"; Expr e_loop; Literal "done"
          -> MLfor (p_e,(down_flag,e_bound),e_step,e_loop)
        | Record_expr fl -> MLrecord fl
        
and Record_expr = 
    parse Literal "{"; Field_list fl; Literal "}" -> fl
        
and Field_list = 
    parse Field1 f1; ( * (parse Literal ";"; Field1 f -> f
                              )) fl
          -> (f1,fl)
        
and Field1 = 
    parse MLIdent id; Literal "="; Fnexpr16 e -> (id,e)
        | MLIdent id -> (id,MLvar id)
        
and Type_constraint = 
    parse Literal ":"; Type ty -> ty
        
and entry Fun_Match = 
    parse Match m -> MLmatch (MLmatching (MLnolabel,m))
        
and entry Function_Match = 
    parse Function_Matching m -> MLmatch m
        
and entry Function_Matching = 
    parse Literal "continuing"; IDENT s; Umatch m
          -> MLmatching (MLlabelled s,m)
        | Umatch m -> MLmatching (MLnolabel,m)
        
and When_expr = 
    parse Expr12 e1 -> e1
        | Literal "_" -> MLconst (mlbool true)
        
and When_Match_case = 
    parse When_expr e1;
          (+ (parse Literal "&|"; When_expr e2; Literal "->"; Expr e3
                    -> (e2,e3)
                  )) el
          -> MLwhen_compound (e1,el)
        | When_expr e1; Literal "->"; Expr e2 -> MLwhen_simple (e1,e2)
        
and When_Match = 
    parse Bar_opt _; When_Match_case c;
          ( * (parse Literal "|"; When_Match_case c -> c
                   )) l
          -> MLwhen (c,l)
        
and entry Match = 
    parse Match1 ml -> rev ml
        
and Match1 = 
    parse Bpatat p; Match_rule mr -> [p,mr]
        | Match1 ml; Literal "|"; Bpatat p; Match_rule mr -> (p,mr)::ml
        
and Match_rule = 
    parse Bpatat p; Match_rule mr
          -> MLaction (MLmatch (MLmatching (MLnolabel,[p,mr])))
        | Literal "->"; Expr e -> MLaction e
        
and entry Umatch_case = 
    parse Pat p; Literal "->"; Expr e -> (p,MLaction e)
        | Pat p; Literal "when"; Expr g; Literal "->"; Expr e
          -> (p,MLguard_action (g,e))
        
and entry Umatch = 
    parse Umatch1 uml -> rev uml
        
and Umatch1 = 
    parse Bar_opt _; Umatch_case umc -> [umc]
        | Umatch1 uml; Literal "|"; Umatch_case umc -> umc::uml
        
and entry Decl = 
    parse Let _; Val_binding vb -> vb
        | Let _; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "type"; Type_binding tb -> MLtype tb
        | Literal "exception"; Exc_binding ebl -> MLexception ebl
        | Decl local_decl; Literal "in"; Decl decl
          -> MLlocal (local_decl,decl)
        | Literal "("; Decl d; Literal ")" -> d
        
and entry Val_binding = 
    parse Val_binding0 vb -> mkdecl vb
        | Val_binding vb1; Literal "and"; Val_binding0 vb2
          -> binarize (vb1,mkdecl vb2)
        | Val_binding vb1; Literal "#and"; Expr0 e
          -> binarize (vb1,mkdecl e)
        
and Let = 
    parse Literal "let" -> ()
        | Literal "value" -> ()
        | Let _; Literal "and" -> ()
        
and Bar_opt = 
    parse -> ()
        | Literal "|" -> ()
        
and Pat_is_expr = 
    parse Bpat p; Literal "="; Expr e -> (p,e)
        
and Ident_is_expr = 
    parse IDENT p; Literal "="; Expr e -> (p,e)
        
and Is = 
    parse Literal "=" -> ()
        | Literal "be" -> ()
        
and Val_binding0 = 
    parse Bpat p; Is _; Expr e -> [p,e]
        | Bpatat p; Beurk b -> [p,b]
        | Bpatat p1; Inf i; Bpatat p2; Is _; Expr e
          -> [MLvarpat i,
              MLmatch
               (MLmatching (MLnolabel,[MLpairpat (p1,p2),MLaction e]))]
          
        | Val_binding0 vb; Literal "|"; Bpatat p; Beurk b -> (p,b)::vb
        
and Beurk = 
    parse Bpatat p; Beurk n
          -> MLmatch (MLmatching (MLnolabel,[p,MLaction n]))
        | Is _; Expr e -> e
        
and entry Type_binding = 
    parse Type_binding_1 tb;
          ( * (parse Literal "and"; Type_binding_1 tb -> tb
                   )) tbl
          -> tb::tbl
        
and Type_binding_1 = 
    parse Type_name id_vta; Literal "=="; Type ty
          -> MLabbrev_type (mk_type_binding (id_vta,ty))
        | Type_name id_vta; Literal "="; Constructor_decl_list cl
          -> MLconcrete_type (mk_type_binding (id_vta,cl))
        | Type_name id_vta; Literal "="; Literal "."; Literal ".";
          Literal "."; Constructor_decl_list cl
          -> MLextend_type (mk_type_binding (id_vta,true,cl))
        | Type_name id_vta; Literal "="; Constructor_decl_list cl;
          Literal "."; Literal "."; Literal "."
          -> MLextend_type (mk_type_binding (id_vta,false,cl))
        | Type_name id_vta; Literal "="; Labels l
          -> MLrecord_type (mk_type_binding (id_vta,l))
        | Type_name id_vta; Literal "="; Constructor_decl_list cl;
          Literal "within"; Labels l
          -> MLview_type (mk_type_binding (id_vta,l,cl))
        | Type_name id_vta
          -> MLunknown_type (mk_type_binding (id_vta,all_the_tags))
        | Type_name id_vta; Literal "with"; Literal "tags"; Expr0 e
          -> MLunknown_type (mk_type_binding (id_vta,e))
        
and Type_name = 
    parse Var_tyargs vta; MLIdent2 id -> (id,vta)
        | Var_ty vt1; Infixes i; Var_ty vt2 -> (i,[vt1; vt2])
        
and Labels = 
    parse Literal "{"; Labs l; Literal "}" -> l
        
and Constr_decl_list = 
    parse ( * (parse Literal "|"; Constructor_decl c -> c
                   )) cl -> cl
        
and entry Constructor_decl_list = 
    parse Bar_opt _; Constructor_decl c; Constr_decl_list cl -> c::cl
        | Bar_opt _; Constructor_decl c; Constr_decl_list cl;
          Literal "|" -> c::cl
        
and entry Constructor_decl = 
    parse Constructor_or_ident id; Literal "of"; Type ty
          -> MLconstruct (id,ty)
        | Constructor_or_ident id -> MLconstruct0 id
        | Mutable _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Lazy _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | Parallel _; Constructor_or_ident id; Literal "of"; Type ty
          -> MLqconstruct (id,standard_plabel_qualificator,ty)
        
and Var_tyargs = 
    parse -> []
        | Var_ty v -> [v]
        | Literal "("; Var_tyl vtl; Var_ty v; Literal ")"
          -> rev (v::vtl)
        
and Var_tyl = 
    parse -> []
        | Var_tyl vtl; Var_ty v; Literal "," -> v::vtl
        
and Lazy = 
    parse Literal "lazy" -> ()
        | Literal "*" -> ()
        
and Parallel = 
    parse Literal "parallel" -> ()
        | Literal "&" -> ()
        
and Mutable = 
    parse Literal "mutable" -> ()
        | Literal "!" -> ()
        
and Labs = 
    parse Label_decl_list l
          -> (match rev l with
                 prefix :: labs -> labs | _ -> system_error "No labels")
          
        
and entry Label_decl_list = 
    parse Label_decl_list ll; Literal ";"; Label_decl l -> l::ll
        | Label_decl l -> [l]
        
and entry Label_decl = 
    parse MLIdent id; Literal ":"; Type ty -> MLlabel (id,ty)
        | Mutable _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Lazy _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_llabel_qualificator,ty)
        | Parallel _; MLIdent id; Literal ":"; Type ty
          -> MLqlabel (id,standard_plabel_qualificator,ty)
        
and entry Exc_binding = 
    parse Constructor_decl cd;
          ( * (parse Literal "and"; Constructor_decl cd -> cd
                   )) cdl
          -> cd::cdl
        
and Pat1 = 
    parse Constructor_or_ident id; Bpatat p -> MLconpat (id,p)
        | Literal "dynamic"; Bpatat p -> MLdynpat p
        | Bpatat p -> p
        
and Pat4 = 
    parse Pat4 p1; Literal ","; Pat4 p2 -> MLpairpat (p1,p2)
        | Pat4 p1; INFIX i; Pat4 p2 -> MLconpat (i,MLpairpat (p1,p2))
        | Pat4 p1; Literal ("::" as c); Pat4 p2
          -> MLconpat (c,MLpairpat (p1,p2))
        | Pat1 p -> p
        
and Pat5 = 
    parse Or_pat orp -> MLorpat orp
        | Pat4 p -> p
        
and Or_pat = 
    parse Pat4 p1; (+ (parse Literal "|"; Pat4 p -> p
                           )) ops
          -> (p1,prefix :: ops)
        | Pat4 p1; Literal "#|"; MLescape e -> (p1,e)
        
and entry Pat = 
    parse Pat5 p; Literal "as"; Bpat1 as_pat -> MLsynpat (p,as_pat)
        | Pat5 p; Literal "within"; Record_pat ps -> MLwithinpat (p,ps)
        | Pat5 p -> p
        
and entry Bpat1 = 
    parse Constante c -> MLconstpat c
        | Literal "_" -> MLwildpat
        | Literal "*" -> MLlazywildpat
        | Constructor s -> MLcon0pat s
        | MLIdent2 id -> MLvarpat id
        | Literal "strict"; MLIdent2 id -> MLstrictpat (MLvarpat id)
        | MLescape e -> e
        | Literal "["; Pats ps; Literal "]" -> ps
        | Record_pat ps -> MLrecordpat ps
        | Literal "("; Pat p; Literal ")" -> p
        | Literal "("; Pat p; Type_constraint str; Literal ")"
          -> MLstraintpat (p,str)
        | Ol_program ol_exp; {MML_to_MLpat ol_exp} oe -> oe
        
and Record_pat = 
    parse Literal "{"; Lab_pats ps; Literal "}" -> ps
        
and Bpatat = 
    parse Bpat1 p; Literal "at"; MLIdent id -> MLoccpat (p,id)
        | Bpat1 p -> p
        
and entry Bpat = 
    parse Bpatat p1; Literal ","; Bpat p2 -> MLpairpat (p1,p2)
        | Bpatat p -> p
        
and Pats = 
    parse Pat p -> MLconpat ("::",MLpairpat (p,MLvarpat ""))
        | Pat p; Literal ";"; Pats pl
          -> MLconpat ("::",MLpairpat (p,pl))
        
and Lab_pat = 
    parse MLIdent id; Literal "="; Pat p -> MLlabelpat (id,p)
        | MLIdent id -> MLlabelpat (id,MLvarpat id)
        | Literal "_" -> MLlabelwildpat
        
and Lab_pats = 
    parse Lab_pat lp; ( * (parse Literal ";"; Lab_pat lp -> lp
                               )) lpl
          -> (lp,lpl)
        
and Ce = 
    parse NUM n -> mlnum n
        | INT i -> mlint i
        | FLOAT f -> mlfloat f
        | RATIO f -> mlratio f
        | BIGINT f -> mlbig_int f
        | CHAR c -> mlchar c
        | STRING s -> mlstring s
        | BOOL b -> mlbool b
        | Literal "("; Literal ")" -> mlnull
        | Literal "{"; Literal "}" -> mlnull
        
and Constante = 
    parse Literal "-"; NUM n with precedence uminus
          -> mlnum (minus_num n)
        | Literal "-"; INT i with precedence uminus
          -> mlint (minus_int i)
        | Literal "-"; FLOAT f with precedence uminus
          -> mlfloat (minus_float f)
        | Literal "-"; RATIO f with precedence uminus
          -> mlratio (minus_ratio f)
        | Literal "-"; BIGINT f with precedence uminus
          -> mlbig_int (minus_big_int f)
        | Ce c -> c
        
and Type1 = 
    parse Var_ty vty -> MLvartyp vty
        | MLIdent2 const -> MLconsttyp (const,[])
        | Literal "("; Type ty; Literal ")" -> ty
        | Type1 tyarg; MLIdent2 tyco -> MLconsttyp (tyco,[tyarg])
        | Literal "("; Typel args; Literal ")"; MLIdent2 ty
          -> MLconsttyp (ty,args)
        | MLescape e -> e
        
and Typel = 
    parse Type ty; (+ (parse Literal ","; Type t -> t
                           )) tyl
          -> ty::prefix :: tyl
        
and Type2 = 
    parse Type1 ty1; Type_infixes tyi; Type2 ty2
          -> MLconsttyp (tyi,[ty1; ty2])
        | Type1 ty -> ty
        
and entry Type = 
    parse Type tysrc; Literal ("->" as arrow); Type tygl
          -> MLconsttyp (arrow,[tysrc; tygl])
        | Type2 ty1; Literal ("*" as b_and); Type ty2
          -> MLconsttyp (b_and,[ty1; ty2])
        | Type2 ty -> ty
        
and Var_ty = 
    parse Literal "'"; MLIdent var -> var
        
and MLIdent0 = 
    parse IDENT var -> var
        | Literal "["; Literal "]" -> ""
        
and MLIdent = 
    parse MLIdent0 var -> var
        | MLInfix i -> i
        
and Prefix_Ident = 
    parse Literal "prefix"; MLInfix i -> i
        
and MLIdent2 = 
    parse MLIdent0 var -> var
        | Prefix_Ident var -> var
        
and Constructor = 
    parse Literal "'"; IDENT id -> "'"^id
        | Literal "prefix"; CInfixes id -> id
        
and Constructor_or_ident = 
    parse Constructor c -> c
        | MLIdent2 id -> id
        
and Inf = 
    parse INFIX i -> i
        | Literal ("+" as p) -> p
        | Literal ("**" as p) -> p
        | Literal ("/" as d) -> d
        | Literal ("<=" as l) -> l
        | Literal (">=" as g) -> g
        | Literal ("<>" as d) -> d
        | Literal ("<" as l) -> l
        | Literal (">" as g) -> g
        | Literal ("::" as c) -> c
        | Literal ("@" as a) -> a
        | Literal ("&" as m) -> m
        | Literal ("or" as d) -> d
        | Literal ("&&" as m) -> m
        | Literal ("||" as d) -> d
        | Literal ("^" as c) -> c
        | Literal ("!=" as a) -> a
        | Literal (":=" as a) -> a
        
and Type_infixes = 
    parse Inf i -> i
        | Literal ("-" as m) -> m
        
and Infixes = 
    parse Type_infixes i -> i
        | Literal ("*" as a) -> a
        | Literal ("==" as a) -> a
        | Literal ("=" as e) -> e
        
and CInfixes = 
    parse Literal "'"; Infixes i -> "'"^i
        
and Prefixes = 
    parse Literal ("not" as n) -> n
        | Literal ("!" as b) -> b
        
and MLInfix = 
    parse Infixes i -> i
        | Prefixes p -> p
        
and MLescape = 
    parse Literal "#"; {parse_caml_expr0 ()} e -> e
        | Literal "{^"; {parse_caml_expr ()} e; Literal "^}" -> e
        
;;

let parse_CAML_Expr = (CAML "Expr").Parse_raw

and parse_CAML_Expr0 = (CAML "Expr0").Parse_raw

and parse_CAML_Expr_non_sequence = (CAML "Expr_non_sequence").Parse_raw

and parse_CAML_MLnum = (CAML "MLnum").Parse_raw

and parse_CAML_MLstring = (CAML "MLstring").Parse_raw

and parse_CAML_MLbool = (CAML "MLbool").Parse_raw

and parse_CAML_MLint = (CAML "MLint").Parse_raw

and parse_CAML_MLchar = (CAML "MLchar").Parse_raw

and parse_CAML_MLfloat = (CAML "MLfloat").Parse_raw

and parse_CAML_MLratio = (CAML "MLratio").Parse_raw

and parse_CAML_MLbig_int = (CAML "MLbig_int").Parse_raw

and parse_CAML_MLvar = (CAML "MLvar").Parse_raw

and parse_CAML_MLvarpat = (CAML "MLvarpat").Parse_raw

and parse_CAML_Match = (CAML "Match").Parse_raw

and parse_CAML_Umatch = (CAML "Umatch").Parse_raw

and parse_CAML_Umatch_case = (CAML "Umatch_case").Parse_raw

and parse_CAML_Function_Match = (CAML "Function_Match").Parse_raw

and parse_CAML_Function_Matching = (CAML "Function_Matching").Parse_raw

and parse_CAML_Fun_Match = (CAML "Fun_Match").Parse_raw

and parse_CAML_Decl = (CAML "Decl").Parse_raw

and parse_CAML_Val_binding = (CAML "Val_binding").Parse_raw

and parse_CAML_Type_binding = (CAML "Type_binding").Parse_raw

and parse_CAML_Constructor_decl_list =
 (CAML "Constructor_decl_list").Parse_raw

and parse_CAML_Constructor_decl = (CAML "Constructor_decl").Parse_raw

and parse_CAML_Label_decl_list = (CAML "Label_decl_list").Parse_raw

and parse_CAML_Label_decl = (CAML "Label_decl").Parse_raw

and parse_CAML_Exc_binding = (CAML "Exc_binding").Parse_raw

and parse_CAML_Pat = (CAML "Pat").Parse_raw

and parse_CAML_Pat0 = (CAML "Bpat1").Parse_raw

and parse_CAML_Let_pat = (CAML "Bpat").Parse_raw

and parse_CAML_Type = (CAML "Type").Parse_raw;;

();;

end module with
 value parse_CAML_Expr
 and parse_CAML_Expr0
 and parse_CAML_Expr_non_sequence
 and parse_CAML_MLnum
 and parse_CAML_MLstring
 and parse_CAML_MLbool
 and parse_CAML_MLint
 and parse_CAML_MLchar
 and parse_CAML_MLfloat
 and parse_CAML_MLratio
 and parse_CAML_MLbig_int
 and parse_CAML_MLvar
 and parse_CAML_MLvarpat
 and parse_CAML_Match
 and parse_CAML_Umatch
 and parse_CAML_Fun_Match
 and parse_CAML_Function_Match
 and parse_CAML_Function_Matching
 and parse_CAML_Umatch_case
 and parse_CAML_Decl
 and parse_CAML_Val_binding
 and parse_CAML_Type_binding
 and parse_CAML_Constructor_decl_list
 and parse_CAML_Constructor_decl
 and parse_CAML_Label_decl_list
 and parse_CAML_Label_decl
 and parse_CAML_Exc_binding
 and parse_CAML_Pat
 and parse_CAML_Pat0
 and parse_CAML_Let_pat
 and parse_CAML_Type;;
