(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* macro_expand.ml Macro expansion of a file                             *)
(*                 Michel Mauny                                          *)
(*                 Pierre Weis                                           *)

#standard arith true;;
#fast arith true;;

system module Macro_Expand;;

let close_all schan outs is=
  protect(
     user_print_on schan;
     close_user_print outs;
     close_in is;
     flush outs;close_out outs;
     ())
;;

let macro_expand_file f1 f2 =
    let F1,F2 = abs_path (f1^".ml"), abs_path (f2^".ml") in
    let is = open_in F1 and os = open_out F2 in
    let old_user_out_channel = !user_out_channel in
    error_message ("Macro expanding "^f1^" into "^f2);
    open_user_print os;
    user_print_on os;
    let vt=!verb_toplevel and sip = !something_is_printed in
    verb_toplevel:=false; something_is_printed := false;
    try while true
        do let S = (parse_caml_syntax_in_channel is) in
           print_newline();print_MLsyntax S;
           print_string ";;";
           print_newline()
        done
    with io_failure "eof" ->
           (verb_toplevel:=vt; something_is_printed := sip;
            close_all old_user_out_channel os is; error_message "Done")
       | reraise ->
            verb_toplevel:=vt; something_is_printed := sip;
            close_all old_user_out_channel os is;
            raise reraise
;;

end module with value macro_expand_file
;;
