(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* latex_type.ml    A latex printer for CAML types                       *)
(*                  Pierre Weis						 *)

#standard arith true;;
#fast arith true;;

let rec gen_var n =
  if le_int (n, 26) then ascii (add_int (96, n))
   else
   let r = mod_int (pred_int n, 26)
   and q = mod_int (pred_int n, 26) in
  ((gen_var q)^(ascii (add_int (97, r))));;

let print_quote () = display_string ("\\hbox");;

let convert_variable = function
  "a" -> "{$\\alpha$}"
 |"b" -> "{$\\beta$}"
 |"c" -> "{$\\gamma$}"
 |"d" -> "{$\\delta$}"
 |"e" -> "{$\\epsilon$}"
 |"f" -> "{$\\phi$}"
 |"g" -> "{$\\varrho$}"
 |"h" -> "{$\\theta$}"
 |"i" -> "{$\\iota$}"
 |"j" -> "{$\\eta$}"
 |"k" -> "{$\\kappa$}"
 |"l" -> "{$\\lambda$}"
 |"m" -> "{$\\mu$}"
 |"n" -> "{$\\nu$}"
 |"o" -> "{$o$}"
 |"p" -> "{$\\pi$}"
 |"q" -> "{$\\chi$}"
 |"r" -> "{$\\rho$}"
 |"s" -> "{$\\sigma$}"
 |"t" -> "{$\\tau$}"
 |"u" -> "{$\\upsilon$}"
 |"v" -> "{$\\psi$}"
 |"w" -> "{$\\omega$}"
 |"x" -> "{$\\xi$}"
 |"y" -> "{$\\varphi$}"
 |"z" -> "{$\\zeta$}"
 | _ -> failwith "convert_variable";;


let rec latex_print_type = function
 |	<:gtype:gtype<^x -> ^y>> as ty ->
          display_string "\\binairetype{\\hbox{$\\rightarrow$}}{";
          print_gtype3 x;
          display_string "}";
          display_string "{";
          latex_print_type y;
          display_string "}"
 |      ty -> print_gtype3 ty


and print_gtype3 = function
 |	<:gtype:gtype<^x * ^y>> as ty ->
          display_string "\\binairetype{\\hbox{$\\times$}}{";
          print_gtype2 x;
          display_string "}";
          display_string "{";
          print_gtype3 y;
          display_string "}"
 |      ty -> print_gtype2 ty

and print_gtype2 = function
     Gconsttype (s, (t1::([t2] as l))) as ty ->
      let name = inv_global_type_for_printing s in
       if is_infix_not_predef_gtype name then
        begin
          display_string"\\binairetype{";
          display_string name;
          display_string "}";
          display_string "{";
          print_gtype1 t1;
          display_string "}";
          display_string "{";
          print_gtype2 t2;
          display_string "}"
        end
       else print_gtype1 ty
 |  ty -> print_gtype1 ty

and print_gtype1 = function continuing print_gtype1
	(Gvartype n) ->
          print_quote();
          display_string (convert_variable (gen_var n))
 |	(Gconsttype(s,[])) ->
          display_string "\\nairetype";
          display_string "{";
          print_ident2 (inv_global_type_for_printing s);
          print_flush();
          display_string "}{}"
 |	(Gconsttype(s,[t])) ->
          display_string "\\nairetype{";
	  print_ident2 (inv_global_type_for_printing s);
          print_flush();
          display_string "}";
          display_string "{";
          print_gtype1 t;
          display_string "}"

 |      (Gconsttype (s, (h::l))) ->
         (let name = inv_global_type_for_printing s in
          if is_infix_gtype name then continue print_gtype1 else
           begin
            display_string"\\nairetype{";
            print_ident2 name;
            print_flush();
            display_string "}";
            display_string "{";
            display_string "(";
            latex_print_type h;
            do_list (fun t -> display_string ",";latex_print_type t) l;
            display_string ") ";
            display_string "}"
           end)

  | ty -> display_string "("; latex_print_type ty; display_string ") "

and inv_global_type_for_printing s =
    (match inv_global_type s with
       (* This type becames out of scope *)
       "-undef",_ -> "(?)"
     | s,_ -> s)
    ? "(???)"

and is_infix_not_predef_gtype s = is_infix s && not (is_predef_infix_gtype s)
and is_infix_gtype s = is_infix s || is_predef_infix_gtype s
and is_predef_infix_gtype s = s = "->" || s = "*"
;;

