(* $Id: format_latex_numbers.ml,v 1.6 92/04/08 20:00:34 weis Exp $ *)
(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* format_latex_numbers.ml Formating big numbers in latex                 *)
(*                   Valerie Menissier                                   *)

module format_latex_numbers 
 using value latex_margin : int ref
;;

#standard arith true;;
#fast arith true;;
#open arith;;

let print_line line = print_string line; print_cut();;

let sys_latex_print_nat (base, before, nat, off, len, after) = 
  open_hovbox (length_string before);
  print_string before;
  let sl = ref (sys_string_list_of_nat (base, nat, off, len))
  (* off_set dans la chaine en te^te de liste *)
  and pos = ref #0
  (* nombre de caracte`res de'ja` e'crits sur la ligne courante *)
  and n = ref #0 in 
    while not (null !sl) do 
       let s = hd !sl in
       let len_s = length_string s in
       let rem_s = sub_int (len_s, !pos)
       and rem_l = sub_int (!latex_margin, !n) in
         begin match compare_int (rem_s, rem_l) with
           #0 -> print_line (sub_string s !pos rem_s); 
                 n := #0;
                 sl := tl !sl;
                 pos := #0
         | #1 -> print_line (sub_string s !pos rem_l);
                 n := #0;
                 pos := add_int (rem_l, !pos)
         | _ -> print_line (sub_string s !pos rem_s);
                  n := add_int (rem_s, !n);
                  sl := tl !sl;
                  pos := #0
         end 
         done;
  print_string after;
  close_box()
;;  

let latex_print_nat nat =
  sys_latex_print_nat (#10, "", nat, #0, 
                       num_digits_nat (nat, #0, length_nat nat), "")
;;

let latex_print_for_read_nat nat =
  sys_latex_print_nat (#10, "#<", nat, #0, 
                       num_digits_nat (nat, #0, length_nat nat), ">")
;;

let sys_latex_print_big_int (base, before, bi, after) = 
  match bi.Sign with
    #0 -> print_string before; print_string "0"; print_string after
  | #-1 -> sys_latex_print_nat (base, before^"-", bi.Abs_Value, #0, 
                                num_digits_big_int bi, after)
  | _ -> sys_latex_print_nat (base, before, bi.Abs_Value, #0, 
                               num_digits_big_int bi, after)
;;

let latex_print_big_int bi = 
  sys_latex_print_big_int (#10, "", bi, "")
;;

let latex_print_for_read_big_int bi = 
  sys_latex_print_big_int (#10, "#(", bi, ")")
;;

let sys_latex_print_ratio (base, before, r, after) = 
  cautious_normalize_ratio_when_printing r;
  sys_latex_print_big_int (base, before, r.Numerator, "");
  print_cut (); print_string "/"; print_break (0,1);
  sys_latex_print_big_int (base, "", r.Denominator, after)
;;

let latex_print_ratio r = 
  sys_latex_print_ratio (#10, "", r, "")
;;

let latex_print_for_read_ratio r = 
  sys_latex_print_ratio (#10, "#[", r, "]")
;;

let sys_latex_print_num (base, before, n, after) = 
  match n with 
    Int i -> print_string before; print_int i; print_string after
  | Big_int bi -> sys_latex_print_big_int (base, before, bi, after)
  | Ratio r -> sys_latex_print_ratio (base, before, r, after)
;;

let latex_print_num n = 
  sys_latex_print_num (#10, "", n, "")
;;

let latex_print_for_read_num n = 
  sys_latex_print_num (#10, "#{", n, "}")
;;

end module with
  value latex_print_for_read_nat
    and latex_print_for_read_big_int
    and latex_print_for_read_ratio
    and latex_print_for_read_num
    and latex_print_nat
    and latex_print_big_int
    and latex_print_ratio
    and latex_print_num
    and sys_latex_print_nat
    and sys_latex_print_big_int
    and sys_latex_print_ratio
    and sys_latex_print_num
;;

(*
 Could be used with printer definitions as in:
#printer latex_print_for_read_nat;;
#printer latex_print_for_read_big_int;;
#printer latex_print_for_read_ratio;;
#printer latex_print_for_read_num;;
*)
