(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* bit_vect.ml   bit_vectors in CAML                                	 *)
(*		 Xavier Leroy						 *)
(*		 Pierre Weis						 *)

#standard arith true;;
#fast arith true;;

type 'a bit_vect = Bit_vect of string;;

let init_bit_vect n = Bit_vect (make_string ((n+7) quo 8) `\000`);;

let nth_bit (idx, Bit_vect s) =
  land(nth_ascii(lshift(idx,-3), s), lshift(1, land(idx,7))) > 0
;;

let set_nth_bit (idx, Bit_vect s) =
  set_nth_ascii(lshift(idx,-3), s,
                lor(nth_ascii(lshift(idx,-3),s), lshift(1, land(idx,7))))
;;

let clear_nth_bit (idx, Bit_vect s) =
  set_nth_ascii(lshift(idx,-3), s,
                land(nth_ascii(lshift(idx,-3),s),
                     lnot(lshift(1, land(idx,7)))))
;;

let set_union_bit_vect (Bit_vect s1, Bit_vect s2,(Bit_vect s3 as result)) =
  if length_string s1 == length_string s2 &&
     length_string s1 == length_string s3 then
   (for i = 0 to pred (length_string s1) do
      set_nth_ascii(i,s3,lor(nth_ascii(i,s1),nth_ascii(i,s2)))
    done;
    result)
  else failwith "union_bit_vect"
;;

let set_intersection_bit_vect
    (Bit_vect s1, Bit_vect s2, (Bit_vect s3 as result)) =
  if length_string s1 == length_string s2 &&
     length_string s1 == length_string s3 then
   (for i = 0 to pred (length_string s1) do
         set_nth_ascii(i,s3,land(nth_ascii(i,s1),nth_ascii(i,s2)))
    done;
    result)
  else failwith "intersect_bit_vect"
;;

let set_complement_bit_vect (Bit_vect s,(Bit_vect s' as result)) =
  if length_string s == length_string s' then
   (for i = 0 to pred (length_string s) do
     set_nth_ascii(i,s',lnot(nth_ascii(i,s)))
    done;
    result)
  else failwith"complement_bit_vect"
;;

let union_bit_vect ((Bit_vect s1 as b1),(Bit_vect s2 as b2)) =
 set_union_bit_vect (b1,b2,Bit_vect (make_string (length_string s1) `\000`));;

let intersection_bit_vect ((Bit_vect s1 as b1),(Bit_vect s2 as b2)) =
 set_intersection_bit_vect
  (b1,b2,Bit_vect (make_string (length_string s1) `\000`));;

let complement_bit_vect ((Bit_vect s1 as b1)) =
 set_complement_bit_vect (b1,Bit_vect (make_string (length_string s1) `\000`))
;;

let equal_bit_vect (Bit_vect s1,Bit_vect s2) = s1 = s2
;;

let included_bit_vect (Bit_vect s1,Bit_vect s2) =
 length_string s1 == length_string s2 &&
 (let result = ref true in
  for i = 0 to length_string s1 do
  let n2 = nth_ascii(i,s2) in
  if lor (n2, nth_ascii(i,s1)) != n2 then result := false;()
  done;
  !result)
;;

let copy_bit_vect (Bit_vect s1) =
    Bit_vect (let s2 = make_string (length_string s1) `\000` in
              for i = 0 to length_string s1 do
              set_nth_char (i,s2,(nth_char (i,s1)))
              done;
              s2)
;;
