#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include "dir.h"

extern int errno;
extern void failwith();
extern bool_t xdr_fake();

typedef struct bitstring { int size; char *ptr; } bitstring;

static struct timeval TIMEOUT = { 25, 0 };

XDR *caml_dir (server, args, argl)
char *server, *args;
int argl;
{
    CLIENT *cl;
    XDR *result;
    enum clnt_stat res;
    bitstring argp;

    cl = clnt_create(server, DIRPROG, DIRVERS, "tcp");
    if (cl == NULL) {
	clnt_pcreateerror(server);
	failwith("caml_dir: create");
    }
    argp.size = argl;
    argp.ptr = args;
    res = clnt_call(cl, READDIR, xdr_fake, &argp, xdr_fake, &result, TIMEOUT);
    if (res != RPC_SUCCESS) {
	clnt_perror(cl, server);
	failwith("caml_dir: call");
    }
    return result;
}
