(* $Id: makeg.ml,v 8.1 91/06/20 14:41:49 ddr Exp $
 *
 * Grammaire de make
 *
 * $Log:	makeg.ml,v $
 * Revision 8.1  91/06/20  14:41:49  ddr
 * - distrib
 * 
 * Revision 7.1  91/05/28  20:51:43  ddr
 * - distrib
 * 
 * Revision 6.2  91/05/25  19:16:37  ddr
 * - type file -> type target
 * - ne relit pas makefile.ml
 * 
 * Revision 6.1  91/04/22  14:52:15  ddr
 * - distrib
 *)

module make_gram using
  value parse_caml_val_binding : unit -> MLdecl;
;

#standard arith true;;
#fast arith true;;

let fun_match cl = MLmatch(MLmatching(MLnolabel,cl));;

grammar for values make_gram =

  rule entry make = parse
    make_alone mk -> mk
  | val_binding vb; "in"; make_alone mk -> MLin(vb, mk)

  and val_binding = parse
    "let"; {parse_caml_val_binding()} vb -> vb

  and make_alone = parse
    "make"; case_list cl ->
      let cl = cl @ <:CAML:Umatch< _ -> raise dont_know>> in
      <:CAML:Expr<makef where rec makef = #(fun_match cl)>>

  and case_list = parse
    one_case c -> c
  | case_list cl; "|"; one_case c -> cl @ c

  and one_case = parse
    {parse_caml_pat()} p; ":"; file_list fl; "->";
    {parse_caml_expr()} f ->
      <:CAML:Umatch<
        (#p) as target -> let m = make_children target #fl makef in
        if m then #f; m
      >>

  and file_list = parse
    {parse_caml_expr()} e -> e
;;

end module with
  value make_gram;
;
