(* $Id: makef.ml,v 8.1 91/06/20 14:41:44 ddr Exp $
 *
 * $Log:	makef.ml,v $
 * Revision 8.1  91/06/20  14:41:44  ddr
 * - distrib
 * 
 * Revision 7.1  91/05/28  20:51:41  ddr
 * - distrib
 * 
 * Revision 6.2  91/05/25  19:16:34  ddr
 * - type file -> type target
 * - ne relit pas makefile.ml
 * 
 * Revision 6.1  91/04/22  14:52:14  ddr
 * - distrib
 *)

module make using
  type timeb = {time: num; millitm: num};
  value fdate : string -> num;
  value ftime : unit -> timeb;
;

#standard arith false;;
#fast arith true;;

exception dont_know
;;

type target =
  'Source of string * string | 'Object of string * string
| 'Core of string | 'Phony of string | 'File of string * string;;

let string_of_target = function
  'Source(d, x) -> "Source "^d^x | 'Object (d, x) -> "Object "^d^x
| 'Core x -> "Core "^x | 'Phony x -> "Phony "^x | 'File (x, y) -> "File "^x^y
;;

let cores_dates = ref ([] : (string * num) list);;

let record_loaded s =
  cores_dates := (s, (ftime()).time)::(except_assoc s !cores_dates);
  ()
;;

let older =
  let date_of_target = function
    'Source(d, x) -> fdate(d^x^".ml")
  | 'Object(d, x) -> fdate(d^x^".lo")
  | 'File (x, y) -> fdate (x^y)
  | 'Core s -> (try assoc s !cores_dates with _ -> -1)
  | 'Phony s -> -1
  in
fun target1 target2 ->
  date_of_target target1 < date_of_target target2

and fexists =
  let test_exists f =
    try let fc = open_in f in close_in fc; true with io_failure _ -> false
  in    
function
  'Source(d, s) -> test_exists(d^s^".ml")
| 'Object(d, s) -> test_exists(d^s^".lo")
| 'File (x, y) -> test_exists (x^y)
| _ -> false
;;

(*
let older target1 target2 =
  display_string (string_of_target target1);
  display_string " older than ";
  display_string (string_of_target target2);
  display_string " ? ";
  let x = read std_in 1 in
  display_newline();
  x = "y"

and fexists target =
  display_string "target ";
  display_string (string_of_target target);
  display_string " exists ? ";
  let x = read std_in 1 in
  display_newline();
  x = "y"
;;
*)
let made_targets = ref ([] : (target * bool) list)
and branch = ref ([] : target list)
;;

let make_if_required makef target =
  try assoc target !made_targets with _ ->
  if mem target !branch then (
    display_string "warning: cyclic dependency on target ";
    display_string (string_of_target target);
    display_newline();
    false
  ) else (
    branch := target::!branch;
    let m = (try makef target with dont_know ->
      if fexists target then false
      else failwith ("don't know how to make "^(string_of_target target))
    ) in
    branch := tl !branch;
    made_targets := (target, m)::!made_targets;
    m
  )
;;

let make_handler makef target =
  made_targets := []; branch := [];
  if not make_if_required makef target then (
    display_string (string_of_target target);
    display_string " is up to date";
    display_newline()
  )
;;

let make_children target depends makef =
  depends = [] or
  it_list (fun m depend -> make_if_required makef depend or m) false depends or
  exists (fun depend -> older target depend) depends
;;

end module with
  type target;
  value make_children;
  value make_handler;
  value record_loaded;
  value cores_dates;
  exception dont_know;
;
